// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Net;

namespace Azure.ResourceManager.Peering.Models
{
    /// <summary> The properties that define an exchange peering facility. </summary>
    public partial class ExchangePeeringFacility
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ExchangePeeringFacility"/>. </summary>
        public ExchangePeeringFacility()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ExchangePeeringFacility"/>. </summary>
        /// <param name="exchangeName"> The name of the exchange peering facility. </param>
        /// <param name="bandwidthInMbps"> The bandwidth of the connection between Microsoft and the exchange peering facility. </param>
        /// <param name="microsoftIPv4Address"> The IPv4 address of Microsoft at the exchange peering facility. </param>
        /// <param name="microsoftIPv6Address"> The IPv6 address of Microsoft at the exchange peering facility. </param>
        /// <param name="facilityIPv4Prefix"> The IPv4 prefixes associated with the exchange peering facility. </param>
        /// <param name="facilityIPv6Prefix"> The IPv6 prefixes associated with the exchange peering facility. </param>
        /// <param name="peeringDBFacilityId"> The PeeringDB.com ID of the facility. </param>
        /// <param name="peeringDBFacilityLink"> The PeeringDB.com URL of the facility. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ExchangePeeringFacility(string exchangeName, int? bandwidthInMbps, IPAddress microsoftIPv4Address, IPAddress microsoftIPv6Address, string facilityIPv4Prefix, string facilityIPv6Prefix, int? peeringDBFacilityId, string peeringDBFacilityLink, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ExchangeName = exchangeName;
            BandwidthInMbps = bandwidthInMbps;
            MicrosoftIPv4Address = microsoftIPv4Address;
            MicrosoftIPv6Address = microsoftIPv6Address;
            FacilityIPv4Prefix = facilityIPv4Prefix;
            FacilityIPv6Prefix = facilityIPv6Prefix;
            PeeringDBFacilityId = peeringDBFacilityId;
            PeeringDBFacilityLink = peeringDBFacilityLink;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The name of the exchange peering facility. </summary>
        public string ExchangeName { get; set; }
        /// <summary> The bandwidth of the connection between Microsoft and the exchange peering facility. </summary>
        public int? BandwidthInMbps { get; set; }
        /// <summary> The IPv4 address of Microsoft at the exchange peering facility. </summary>
        public IPAddress MicrosoftIPv4Address { get; set; }
        /// <summary> The IPv6 address of Microsoft at the exchange peering facility. </summary>
        public IPAddress MicrosoftIPv6Address { get; set; }
        /// <summary> The IPv4 prefixes associated with the exchange peering facility. </summary>
        public string FacilityIPv4Prefix { get; set; }
        /// <summary> The IPv6 prefixes associated with the exchange peering facility. </summary>
        public string FacilityIPv6Prefix { get; set; }
        /// <summary> The PeeringDB.com ID of the facility. </summary>
        public int? PeeringDBFacilityId { get; set; }
        /// <summary> The PeeringDB.com URL of the facility. </summary>
        public string PeeringDBFacilityLink { get; set; }
    }
}
