// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Peering.Models
{
    /// <summary> Class for CheckServiceProviderAvailabilityInput. </summary>
    public partial class CheckPeeringServiceProviderAvailabilityContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CheckPeeringServiceProviderAvailabilityContent"/>. </summary>
        public CheckPeeringServiceProviderAvailabilityContent()
        {
        }

        /// <summary> Initializes a new instance of <see cref="CheckPeeringServiceProviderAvailabilityContent"/>. </summary>
        /// <param name="peeringServiceLocation"> Gets or sets the peering service location. </param>
        /// <param name="peeringServiceProvider"> Gets or sets the peering service provider. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CheckPeeringServiceProviderAvailabilityContent(string peeringServiceLocation, string peeringServiceProvider, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PeeringServiceLocation = peeringServiceLocation;
            PeeringServiceProvider = peeringServiceProvider;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the peering service location. </summary>
        public string PeeringServiceLocation { get; set; }
        /// <summary> Gets or sets the peering service provider. </summary>
        public string PeeringServiceProvider { get; set; }
    }
}
