// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Peering.Models
{
    public partial class CheckPeeringServiceProviderAvailabilityContent : IUtf8JsonSerializable, IJsonModel<CheckPeeringServiceProviderAvailabilityContent>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<CheckPeeringServiceProviderAvailabilityContent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<CheckPeeringServiceProviderAvailabilityContent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CheckPeeringServiceProviderAvailabilityContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CheckPeeringServiceProviderAvailabilityContent)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(PeeringServiceLocation))
            {
                writer.WritePropertyName("peeringServiceLocation"u8);
                writer.WriteStringValue(PeeringServiceLocation);
            }
            if (Optional.IsDefined(PeeringServiceProvider))
            {
                writer.WritePropertyName("peeringServiceProvider"u8);
                writer.WriteStringValue(PeeringServiceProvider);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        CheckPeeringServiceProviderAvailabilityContent IJsonModel<CheckPeeringServiceProviderAvailabilityContent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CheckPeeringServiceProviderAvailabilityContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CheckPeeringServiceProviderAvailabilityContent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeCheckPeeringServiceProviderAvailabilityContent(document.RootElement, options);
        }

        internal static CheckPeeringServiceProviderAvailabilityContent DeserializeCheckPeeringServiceProviderAvailabilityContent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string peeringServiceLocation = default;
            string peeringServiceProvider = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("peeringServiceLocation"u8))
                {
                    peeringServiceLocation = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("peeringServiceProvider"u8))
                {
                    peeringServiceProvider = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new CheckPeeringServiceProviderAvailabilityContent(peeringServiceLocation, peeringServiceProvider, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<CheckPeeringServiceProviderAvailabilityContent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CheckPeeringServiceProviderAvailabilityContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(CheckPeeringServiceProviderAvailabilityContent)} does not support writing '{options.Format}' format.");
            }
        }

        CheckPeeringServiceProviderAvailabilityContent IPersistableModel<CheckPeeringServiceProviderAvailabilityContent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CheckPeeringServiceProviderAvailabilityContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeCheckPeeringServiceProviderAvailabilityContent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(CheckPeeringServiceProviderAvailabilityContent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<CheckPeeringServiceProviderAvailabilityContent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
