// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Peering.Models
{
    /// <summary> The CDN peering prefix. </summary>
    public partial class CdnPeeringPrefix : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CdnPeeringPrefix"/>. </summary>
        public CdnPeeringPrefix()
        {
        }

        /// <summary> Initializes a new instance of <see cref="CdnPeeringPrefix"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="prefix"> The prefix. </param>
        /// <param name="azureRegion"> The Azure region. </param>
        /// <param name="azureService"> The Azure service. </param>
        /// <param name="isPrimaryRegion"> The flag that indicates whether or not this is the primary region. </param>
        /// <param name="bgpCommunity"> The BGP Community. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CdnPeeringPrefix(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string prefix, AzureLocation? azureRegion, string azureService, bool? isPrimaryRegion, string bgpCommunity, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            Prefix = prefix;
            AzureRegion = azureRegion;
            AzureService = azureService;
            IsPrimaryRegion = isPrimaryRegion;
            BgpCommunity = bgpCommunity;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The prefix. </summary>
        public string Prefix { get; }
        /// <summary> The Azure region. </summary>
        public AzureLocation? AzureRegion { get; }
        /// <summary> The Azure service. </summary>
        public string AzureService { get; }
        /// <summary> The flag that indicates whether or not this is the primary region. </summary>
        public bool? IsPrimaryRegion { get; }
        /// <summary> The BGP Community. </summary>
        public string BgpCommunity { get; }
    }
}
