// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Peering.Models
{
    public partial class CdnPeeringPrefix : IUtf8JsonSerializable, IJsonModel<CdnPeeringPrefix>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<CdnPeeringPrefix>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<CdnPeeringPrefix>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CdnPeeringPrefix>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CdnPeeringPrefix)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (options.Format != "W" && Optional.IsDefined(Prefix))
            {
                writer.WritePropertyName("prefix"u8);
                writer.WriteStringValue(Prefix);
            }
            if (options.Format != "W" && Optional.IsDefined(AzureRegion))
            {
                writer.WritePropertyName("azureRegion"u8);
                writer.WriteStringValue(AzureRegion.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(AzureService))
            {
                writer.WritePropertyName("azureService"u8);
                writer.WriteStringValue(AzureService);
            }
            if (options.Format != "W" && Optional.IsDefined(IsPrimaryRegion))
            {
                writer.WritePropertyName("isPrimaryRegion"u8);
                writer.WriteBooleanValue(IsPrimaryRegion.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(BgpCommunity))
            {
                writer.WritePropertyName("bgpCommunity"u8);
                writer.WriteStringValue(BgpCommunity);
            }
            writer.WriteEndObject();
        }

        CdnPeeringPrefix IJsonModel<CdnPeeringPrefix>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CdnPeeringPrefix>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CdnPeeringPrefix)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeCdnPeeringPrefix(document.RootElement, options);
        }

        internal static CdnPeeringPrefix DeserializeCdnPeeringPrefix(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            string prefix = default;
            AzureLocation? azureRegion = default;
            string azureService = default;
            bool? isPrimaryRegion = default;
            string bgpCommunity = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("prefix"u8))
                        {
                            prefix = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("azureRegion"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            azureRegion = new AzureLocation(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("azureService"u8))
                        {
                            azureService = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("isPrimaryRegion"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            isPrimaryRegion = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("bgpCommunity"u8))
                        {
                            bgpCommunity = property0.Value.GetString();
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new CdnPeeringPrefix(
                id,
                name,
                type,
                systemData,
                prefix,
                azureRegion,
                azureService,
                isPrimaryRegion,
                bgpCommunity,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<CdnPeeringPrefix>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CdnPeeringPrefix>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(CdnPeeringPrefix)} does not support writing '{options.Format}' format.");
            }
        }

        CdnPeeringPrefix IPersistableModel<CdnPeeringPrefix>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CdnPeeringPrefix>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeCdnPeeringPrefix(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(CdnPeeringPrefix)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<CdnPeeringPrefix>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
