// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.Peering.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockablePeeringArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockablePeeringArmClient"/> class for mocking. </summary>
        protected MockablePeeringArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockablePeeringArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockablePeeringArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockablePeeringArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="PeerAsnResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="PeerAsnResource.CreateResourceIdentifier" /> to create a <see cref="PeerAsnResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="PeerAsnResource"/> object. </returns>
        public virtual PeerAsnResource GetPeerAsnResource(ResourceIdentifier id)
        {
            PeerAsnResource.ValidateResourceId(id);
            return new PeerAsnResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="PeeringRegisteredAsnResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="PeeringRegisteredAsnResource.CreateResourceIdentifier" /> to create a <see cref="PeeringRegisteredAsnResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="PeeringRegisteredAsnResource"/> object. </returns>
        public virtual PeeringRegisteredAsnResource GetPeeringRegisteredAsnResource(ResourceIdentifier id)
        {
            PeeringRegisteredAsnResource.ValidateResourceId(id);
            return new PeeringRegisteredAsnResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="PeeringRegisteredPrefixResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="PeeringRegisteredPrefixResource.CreateResourceIdentifier" /> to create a <see cref="PeeringRegisteredPrefixResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="PeeringRegisteredPrefixResource"/> object. </returns>
        public virtual PeeringRegisteredPrefixResource GetPeeringRegisteredPrefixResource(ResourceIdentifier id)
        {
            PeeringRegisteredPrefixResource.ValidateResourceId(id);
            return new PeeringRegisteredPrefixResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="PeeringResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="PeeringResource.CreateResourceIdentifier" /> to create a <see cref="PeeringResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="PeeringResource"/> object. </returns>
        public virtual PeeringResource GetPeeringResource(ResourceIdentifier id)
        {
            PeeringResource.ValidateResourceId(id);
            return new PeeringResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ConnectionMonitorTestResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ConnectionMonitorTestResource.CreateResourceIdentifier" /> to create a <see cref="ConnectionMonitorTestResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ConnectionMonitorTestResource"/> object. </returns>
        public virtual ConnectionMonitorTestResource GetConnectionMonitorTestResource(ResourceIdentifier id)
        {
            ConnectionMonitorTestResource.ValidateResourceId(id);
            return new ConnectionMonitorTestResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="PeeringServicePrefixResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="PeeringServicePrefixResource.CreateResourceIdentifier" /> to create a <see cref="PeeringServicePrefixResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="PeeringServicePrefixResource"/> object. </returns>
        public virtual PeeringServicePrefixResource GetPeeringServicePrefixResource(ResourceIdentifier id)
        {
            PeeringServicePrefixResource.ValidateResourceId(id);
            return new PeeringServicePrefixResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="PeeringServiceResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="PeeringServiceResource.CreateResourceIdentifier" /> to create a <see cref="PeeringServiceResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="PeeringServiceResource"/> object. </returns>
        public virtual PeeringServiceResource GetPeeringServiceResource(ResourceIdentifier id)
        {
            PeeringServiceResource.ValidateResourceId(id);
            return new PeeringServiceResource(Client, id);
        }
    }
}
