// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Peering.Models;

namespace Azure.ResourceManager.Peering
{
    /// <summary>
    /// A class representing the ConnectionMonitorTest data model.
    /// The Connection Monitor Test class.
    /// </summary>
    public partial class ConnectionMonitorTestData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ConnectionMonitorTestData"/>. </summary>
        public ConnectionMonitorTestData()
        {
            Path = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="ConnectionMonitorTestData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="sourceAgent"> The Connection Monitor test source agent. </param>
        /// <param name="destination"> The Connection Monitor test destination. </param>
        /// <param name="destinationPort"> The Connection Monitor test destination port. </param>
        /// <param name="testFrequencyInSec"> The Connection Monitor test frequency in seconds. </param>
        /// <param name="isTestSuccessful"> The flag that indicates if the Connection Monitor test is successful or not. </param>
        /// <param name="path"> The path representing the Connection Monitor test. </param>
        /// <param name="provisioningState"> The provisioning state of the resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ConnectionMonitorTestData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string sourceAgent, string destination, int? destinationPort, int? testFrequencyInSec, bool? isTestSuccessful, IReadOnlyList<string> path, PeeringProvisioningState? provisioningState, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            SourceAgent = sourceAgent;
            Destination = destination;
            DestinationPort = destinationPort;
            TestFrequencyInSec = testFrequencyInSec;
            IsTestSuccessful = isTestSuccessful;
            Path = path;
            ProvisioningState = provisioningState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The Connection Monitor test source agent. </summary>
        public string SourceAgent { get; set; }
        /// <summary> The Connection Monitor test destination. </summary>
        public string Destination { get; set; }
        /// <summary> The Connection Monitor test destination port. </summary>
        public int? DestinationPort { get; set; }
        /// <summary> The Connection Monitor test frequency in seconds. </summary>
        public int? TestFrequencyInSec { get; set; }
        /// <summary> The flag that indicates if the Connection Monitor test is successful or not. </summary>
        public bool? IsTestSuccessful { get; }
        /// <summary> The path representing the Connection Monitor test. </summary>
        public IReadOnlyList<string> Path { get; }
        /// <summary> The provisioning state of the resource. </summary>
        public PeeringProvisioningState? ProvisioningState { get; }
    }
}
