// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.Peering
{
    /// <summary>
    /// A class representing a collection of <see cref="ConnectionMonitorTestResource"/> and their operations.
    /// Each <see cref="ConnectionMonitorTestResource"/> in the collection will belong to the same instance of <see cref="PeeringServiceResource"/>.
    /// To get a <see cref="ConnectionMonitorTestCollection"/> instance call the GetConnectionMonitorTests method from an instance of <see cref="PeeringServiceResource"/>.
    /// </summary>
    public partial class ConnectionMonitorTestCollection : ArmCollection, IEnumerable<ConnectionMonitorTestResource>, IAsyncEnumerable<ConnectionMonitorTestResource>
    {
        private readonly ClientDiagnostics _connectionMonitorTestClientDiagnostics;
        private readonly ConnectionMonitorTestsRestOperations _connectionMonitorTestRestClient;

        /// <summary> Initializes a new instance of the <see cref="ConnectionMonitorTestCollection"/> class for mocking. </summary>
        protected ConnectionMonitorTestCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="ConnectionMonitorTestCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal ConnectionMonitorTestCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _connectionMonitorTestClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Peering", ConnectionMonitorTestResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ConnectionMonitorTestResource.ResourceType, out string connectionMonitorTestApiVersion);
            _connectionMonitorTestRestClient = new ConnectionMonitorTestsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, connectionMonitorTestApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != PeeringServiceResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, PeeringServiceResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates or updates a connection monitor test with the specified name under the given subscription, resource group and peering service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Peering/peeringServices/{peeringServiceName}/connectionMonitorTests/{connectionMonitorTestName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConnectionMonitorTests_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-10-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectionMonitorTestResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="connectionMonitorTestName"> The name of the connection monitor test. </param>
        /// <param name="data"> The properties needed to create a connection monitor test. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="connectionMonitorTestName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="connectionMonitorTestName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<ConnectionMonitorTestResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string connectionMonitorTestName, ConnectionMonitorTestData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(connectionMonitorTestName, nameof(connectionMonitorTestName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _connectionMonitorTestClientDiagnostics.CreateScope("ConnectionMonitorTestCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _connectionMonitorTestRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, connectionMonitorTestName, data, cancellationToken).ConfigureAwait(false);
                var uri = _connectionMonitorTestRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, connectionMonitorTestName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new PeeringArmOperation<ConnectionMonitorTestResource>(Response.FromValue(new ConnectionMonitorTestResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates a connection monitor test with the specified name under the given subscription, resource group and peering service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Peering/peeringServices/{peeringServiceName}/connectionMonitorTests/{connectionMonitorTestName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConnectionMonitorTests_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-10-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectionMonitorTestResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="connectionMonitorTestName"> The name of the connection monitor test. </param>
        /// <param name="data"> The properties needed to create a connection monitor test. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="connectionMonitorTestName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="connectionMonitorTestName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<ConnectionMonitorTestResource> CreateOrUpdate(WaitUntil waitUntil, string connectionMonitorTestName, ConnectionMonitorTestData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(connectionMonitorTestName, nameof(connectionMonitorTestName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _connectionMonitorTestClientDiagnostics.CreateScope("ConnectionMonitorTestCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _connectionMonitorTestRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, connectionMonitorTestName, data, cancellationToken);
                var uri = _connectionMonitorTestRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, connectionMonitorTestName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new PeeringArmOperation<ConnectionMonitorTestResource>(Response.FromValue(new ConnectionMonitorTestResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets an existing connection monitor test with the specified name under the given subscription, resource group and peering service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Peering/peeringServices/{peeringServiceName}/connectionMonitorTests/{connectionMonitorTestName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConnectionMonitorTests_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-10-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectionMonitorTestResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="connectionMonitorTestName"> The name of the connection monitor test. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="connectionMonitorTestName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="connectionMonitorTestName"/> is null. </exception>
        public virtual async Task<Response<ConnectionMonitorTestResource>> GetAsync(string connectionMonitorTestName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(connectionMonitorTestName, nameof(connectionMonitorTestName));

            using var scope = _connectionMonitorTestClientDiagnostics.CreateScope("ConnectionMonitorTestCollection.Get");
            scope.Start();
            try
            {
                var response = await _connectionMonitorTestRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, connectionMonitorTestName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ConnectionMonitorTestResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets an existing connection monitor test with the specified name under the given subscription, resource group and peering service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Peering/peeringServices/{peeringServiceName}/connectionMonitorTests/{connectionMonitorTestName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConnectionMonitorTests_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-10-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectionMonitorTestResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="connectionMonitorTestName"> The name of the connection monitor test. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="connectionMonitorTestName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="connectionMonitorTestName"/> is null. </exception>
        public virtual Response<ConnectionMonitorTestResource> Get(string connectionMonitorTestName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(connectionMonitorTestName, nameof(connectionMonitorTestName));

            using var scope = _connectionMonitorTestClientDiagnostics.CreateScope("ConnectionMonitorTestCollection.Get");
            scope.Start();
            try
            {
                var response = _connectionMonitorTestRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, connectionMonitorTestName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ConnectionMonitorTestResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists all connection monitor tests under the given subscription, resource group and peering service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Peering/peeringServices/{peeringServiceName}/connectionMonitorTests</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConnectionMonitorTests_ListByPeeringService</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-10-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectionMonitorTestResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="ConnectionMonitorTestResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<ConnectionMonitorTestResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _connectionMonitorTestRestClient.CreateListByPeeringServiceRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _connectionMonitorTestRestClient.CreateListByPeeringServiceNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new ConnectionMonitorTestResource(Client, ConnectionMonitorTestData.DeserializeConnectionMonitorTestData(e)), _connectionMonitorTestClientDiagnostics, Pipeline, "ConnectionMonitorTestCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists all connection monitor tests under the given subscription, resource group and peering service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Peering/peeringServices/{peeringServiceName}/connectionMonitorTests</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConnectionMonitorTests_ListByPeeringService</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-10-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectionMonitorTestResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="ConnectionMonitorTestResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<ConnectionMonitorTestResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _connectionMonitorTestRestClient.CreateListByPeeringServiceRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _connectionMonitorTestRestClient.CreateListByPeeringServiceNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new ConnectionMonitorTestResource(Client, ConnectionMonitorTestData.DeserializeConnectionMonitorTestData(e)), _connectionMonitorTestClientDiagnostics, Pipeline, "ConnectionMonitorTestCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Peering/peeringServices/{peeringServiceName}/connectionMonitorTests/{connectionMonitorTestName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConnectionMonitorTests_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-10-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectionMonitorTestResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="connectionMonitorTestName"> The name of the connection monitor test. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="connectionMonitorTestName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="connectionMonitorTestName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string connectionMonitorTestName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(connectionMonitorTestName, nameof(connectionMonitorTestName));

            using var scope = _connectionMonitorTestClientDiagnostics.CreateScope("ConnectionMonitorTestCollection.Exists");
            scope.Start();
            try
            {
                var response = await _connectionMonitorTestRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, connectionMonitorTestName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Peering/peeringServices/{peeringServiceName}/connectionMonitorTests/{connectionMonitorTestName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConnectionMonitorTests_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-10-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectionMonitorTestResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="connectionMonitorTestName"> The name of the connection monitor test. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="connectionMonitorTestName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="connectionMonitorTestName"/> is null. </exception>
        public virtual Response<bool> Exists(string connectionMonitorTestName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(connectionMonitorTestName, nameof(connectionMonitorTestName));

            using var scope = _connectionMonitorTestClientDiagnostics.CreateScope("ConnectionMonitorTestCollection.Exists");
            scope.Start();
            try
            {
                var response = _connectionMonitorTestRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, connectionMonitorTestName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Peering/peeringServices/{peeringServiceName}/connectionMonitorTests/{connectionMonitorTestName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConnectionMonitorTests_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-10-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectionMonitorTestResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="connectionMonitorTestName"> The name of the connection monitor test. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="connectionMonitorTestName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="connectionMonitorTestName"/> is null. </exception>
        public virtual async Task<NullableResponse<ConnectionMonitorTestResource>> GetIfExistsAsync(string connectionMonitorTestName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(connectionMonitorTestName, nameof(connectionMonitorTestName));

            using var scope = _connectionMonitorTestClientDiagnostics.CreateScope("ConnectionMonitorTestCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _connectionMonitorTestRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, connectionMonitorTestName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<ConnectionMonitorTestResource>(response.GetRawResponse());
                return Response.FromValue(new ConnectionMonitorTestResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Peering/peeringServices/{peeringServiceName}/connectionMonitorTests/{connectionMonitorTestName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConnectionMonitorTests_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-10-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ConnectionMonitorTestResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="connectionMonitorTestName"> The name of the connection monitor test. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="connectionMonitorTestName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="connectionMonitorTestName"/> is null. </exception>
        public virtual NullableResponse<ConnectionMonitorTestResource> GetIfExists(string connectionMonitorTestName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(connectionMonitorTestName, nameof(connectionMonitorTestName));

            using var scope = _connectionMonitorTestClientDiagnostics.CreateScope("ConnectionMonitorTestCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _connectionMonitorTestRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, connectionMonitorTestName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<ConnectionMonitorTestResource>(response.GetRawResponse());
                return Response.FromValue(new ConnectionMonitorTestResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<ConnectionMonitorTestResource> IEnumerable<ConnectionMonitorTestResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<ConnectionMonitorTestResource> IAsyncEnumerable<ConnectionMonitorTestResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
