// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Peering.Samples
{
    public partial class Sample_PeeringRegisteredAsnCollection
    {
        // Get a registered ASN associated with the peering
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetARegisteredASNAssociatedWithThePeering()
        {
            // Generated from example definition: specification/peering/resource-manager/Microsoft.Peering/stable/2022-10-01/examples/GetRegisteredAsn.json
            // this example is just showing the usage of "RegisteredAsns_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PeeringResource created on azure
            // for more information of creating PeeringResource, please refer to the document of PeeringResource
            string subscriptionId = "subId";
            string resourceGroupName = "rgName";
            string peeringName = "peeringName";
            ResourceIdentifier peeringResourceId = PeeringResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, peeringName);
            PeeringResource peering = client.GetPeeringResource(peeringResourceId);

            // get the collection of this PeeringRegisteredAsnResource
            PeeringRegisteredAsnCollection collection = peering.GetPeeringRegisteredAsns();

            // invoke the operation
            string registeredAsnName = "registeredAsnName0";
            PeeringRegisteredAsnResource result = await collection.GetAsync(registeredAsnName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PeeringRegisteredAsnData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a registered ASN associated with the peering
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetARegisteredASNAssociatedWithThePeering()
        {
            // Generated from example definition: specification/peering/resource-manager/Microsoft.Peering/stable/2022-10-01/examples/GetRegisteredAsn.json
            // this example is just showing the usage of "RegisteredAsns_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PeeringResource created on azure
            // for more information of creating PeeringResource, please refer to the document of PeeringResource
            string subscriptionId = "subId";
            string resourceGroupName = "rgName";
            string peeringName = "peeringName";
            ResourceIdentifier peeringResourceId = PeeringResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, peeringName);
            PeeringResource peering = client.GetPeeringResource(peeringResourceId);

            // get the collection of this PeeringRegisteredAsnResource
            PeeringRegisteredAsnCollection collection = peering.GetPeeringRegisteredAsns();

            // invoke the operation
            string registeredAsnName = "registeredAsnName0";
            bool result = await collection.ExistsAsync(registeredAsnName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get a registered ASN associated with the peering
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetARegisteredASNAssociatedWithThePeering()
        {
            // Generated from example definition: specification/peering/resource-manager/Microsoft.Peering/stable/2022-10-01/examples/GetRegisteredAsn.json
            // this example is just showing the usage of "RegisteredAsns_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PeeringResource created on azure
            // for more information of creating PeeringResource, please refer to the document of PeeringResource
            string subscriptionId = "subId";
            string resourceGroupName = "rgName";
            string peeringName = "peeringName";
            ResourceIdentifier peeringResourceId = PeeringResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, peeringName);
            PeeringResource peering = client.GetPeeringResource(peeringResourceId);

            // get the collection of this PeeringRegisteredAsnResource
            PeeringRegisteredAsnCollection collection = peering.GetPeeringRegisteredAsns();

            // invoke the operation
            string registeredAsnName = "registeredAsnName0";
            NullableResponse<PeeringRegisteredAsnResource> response = await collection.GetIfExistsAsync(registeredAsnName);
            PeeringRegisteredAsnResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                PeeringRegisteredAsnData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Create or update a registered ASN for the peering
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateOrUpdateARegisteredASNForThePeering()
        {
            // Generated from example definition: specification/peering/resource-manager/Microsoft.Peering/stable/2022-10-01/examples/CreateRegisteredAsn.json
            // this example is just showing the usage of "RegisteredAsns_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PeeringResource created on azure
            // for more information of creating PeeringResource, please refer to the document of PeeringResource
            string subscriptionId = "subId";
            string resourceGroupName = "rgName";
            string peeringName = "peeringName";
            ResourceIdentifier peeringResourceId = PeeringResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, peeringName);
            PeeringResource peering = client.GetPeeringResource(peeringResourceId);

            // get the collection of this PeeringRegisteredAsnResource
            PeeringRegisteredAsnCollection collection = peering.GetPeeringRegisteredAsns();

            // invoke the operation
            string registeredAsnName = "registeredAsnName";
            PeeringRegisteredAsnData data = new PeeringRegisteredAsnData()
            {
                Asn = 65000,
            };
            ArmOperation<PeeringRegisteredAsnResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, registeredAsnName, data);
            PeeringRegisteredAsnResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PeeringRegisteredAsnData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // List all the registered ASNs associated with the peering
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListAllTheRegisteredASNsAssociatedWithThePeering()
        {
            // Generated from example definition: specification/peering/resource-manager/Microsoft.Peering/stable/2022-10-01/examples/ListRegisteredAsnsByPeering.json
            // this example is just showing the usage of "RegisteredAsns_ListByPeering" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PeeringResource created on azure
            // for more information of creating PeeringResource, please refer to the document of PeeringResource
            string subscriptionId = "subId";
            string resourceGroupName = "rgName";
            string peeringName = "peeringName";
            ResourceIdentifier peeringResourceId = PeeringResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, peeringName);
            PeeringResource peering = client.GetPeeringResource(peeringResourceId);

            // get the collection of this PeeringRegisteredAsnResource
            PeeringRegisteredAsnCollection collection = peering.GetPeeringRegisteredAsns();

            // invoke the operation and iterate over the result
            await foreach (PeeringRegisteredAsnResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                PeeringRegisteredAsnData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
