// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Peering.Samples
{
    public partial class Sample_ConnectionMonitorTestResource
    {
        // Get Connection Monitor Test
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetConnectionMonitorTest()
        {
            // Generated from example definition: specification/peering/resource-manager/Microsoft.Peering/stable/2022-10-01/examples/GetConnectionMonitorTest.json
            // this example is just showing the usage of "ConnectionMonitorTests_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ConnectionMonitorTestResource created on azure
            // for more information of creating ConnectionMonitorTestResource, please refer to the document of ConnectionMonitorTestResource
            string subscriptionId = "subId";
            string resourceGroupName = "rgName";
            string peeringServiceName = "peeringServiceName";
            string connectionMonitorTestName = "connectionMonitorTestName";
            ResourceIdentifier connectionMonitorTestResourceId = ConnectionMonitorTestResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, peeringServiceName, connectionMonitorTestName);
            ConnectionMonitorTestResource connectionMonitorTest = client.GetConnectionMonitorTestResource(connectionMonitorTestResourceId);

            // invoke the operation
            ConnectionMonitorTestResource result = await connectionMonitorTest.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ConnectionMonitorTestData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create or Update Connection Monitor Test
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateOrUpdateConnectionMonitorTest()
        {
            // Generated from example definition: specification/peering/resource-manager/Microsoft.Peering/stable/2022-10-01/examples/CreateOrUpdateConnectionMonitorTest.json
            // this example is just showing the usage of "ConnectionMonitorTests_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ConnectionMonitorTestResource created on azure
            // for more information of creating ConnectionMonitorTestResource, please refer to the document of ConnectionMonitorTestResource
            string subscriptionId = "subId";
            string resourceGroupName = "rgName";
            string peeringServiceName = "peeringServiceName";
            string connectionMonitorTestName = "connectionMonitorTestName";
            ResourceIdentifier connectionMonitorTestResourceId = ConnectionMonitorTestResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, peeringServiceName, connectionMonitorTestName);
            ConnectionMonitorTestResource connectionMonitorTest = client.GetConnectionMonitorTestResource(connectionMonitorTestResourceId);

            // invoke the operation
            ConnectionMonitorTestData data = new ConnectionMonitorTestData()
            {
                SourceAgent = "Example Source Agent",
                Destination = "Example Destination",
                DestinationPort = 443,
                TestFrequencyInSec = 30,
            };
            ArmOperation<ConnectionMonitorTestResource> lro = await connectionMonitorTest.UpdateAsync(WaitUntil.Completed, data);
            ConnectionMonitorTestResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ConnectionMonitorTestData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete Connection Monitor Test
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteConnectionMonitorTest()
        {
            // Generated from example definition: specification/peering/resource-manager/Microsoft.Peering/stable/2022-10-01/examples/DeleteConnectionMonitorTest.json
            // this example is just showing the usage of "ConnectionMonitorTests_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ConnectionMonitorTestResource created on azure
            // for more information of creating ConnectionMonitorTestResource, please refer to the document of ConnectionMonitorTestResource
            string subscriptionId = "subId";
            string resourceGroupName = "rgName";
            string peeringServiceName = "peeringServiceName";
            string connectionMonitorTestName = "connectionMonitorTestName";
            ResourceIdentifier connectionMonitorTestResourceId = ConnectionMonitorTestResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, peeringServiceName, connectionMonitorTestName);
            ConnectionMonitorTestResource connectionMonitorTest = client.GetConnectionMonitorTestResource(connectionMonitorTestResourceId);

            // invoke the operation
            await connectionMonitorTest.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
