// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw
{
    /// <summary>
    /// A Class representing a PaloAltoNetworksFirewallStatus along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct a <see cref="PaloAltoNetworksFirewallStatusResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetPaloAltoNetworksFirewallStatusResource method.
    /// Otherwise you can get one from its parent resource <see cref="PaloAltoNetworksFirewallResource"/> using the GetPaloAltoNetworksFirewallStatus method.
    /// </summary>
    public partial class PaloAltoNetworksFirewallStatusResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="PaloAltoNetworksFirewallStatusResource"/> instance. </summary>
        /// <param name="subscriptionId"> The subscriptionId. </param>
        /// <param name="resourceGroupName"> The resourceGroupName. </param>
        /// <param name="firewallName"> The firewallName. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string subscriptionId, string resourceGroupName, string firewallName)
        {
            var resourceId = $"/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/PaloAltoNetworks.Cloudngfw/firewalls/{firewallName}/statuses/default";
            return new ResourceIdentifier(resourceId);
        }

        private readonly ClientDiagnostics _paloAltoNetworksFirewallStatusFirewallStatusClientDiagnostics;
        private readonly FirewallStatusRestOperations _paloAltoNetworksFirewallStatusFirewallStatusRestClient;
        private readonly PaloAltoNetworksFirewallStatusData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "PaloAltoNetworks.Cloudngfw/firewalls/statuses";

        /// <summary> Initializes a new instance of the <see cref="PaloAltoNetworksFirewallStatusResource"/> class for mocking. </summary>
        protected PaloAltoNetworksFirewallStatusResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="PaloAltoNetworksFirewallStatusResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal PaloAltoNetworksFirewallStatusResource(ArmClient client, PaloAltoNetworksFirewallStatusData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="PaloAltoNetworksFirewallStatusResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal PaloAltoNetworksFirewallStatusResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _paloAltoNetworksFirewallStatusFirewallStatusClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.PaloAltoNetworks.Ngfw", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string paloAltoNetworksFirewallStatusFirewallStatusApiVersion);
            _paloAltoNetworksFirewallStatusFirewallStatusRestClient = new FirewallStatusRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, paloAltoNetworksFirewallStatusFirewallStatusApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual PaloAltoNetworksFirewallStatusData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary>
        /// Get a FirewallStatusResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/PaloAltoNetworks.Cloudngfw/firewalls/{firewallName}/statuses/default</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>FirewallStatus_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="PaloAltoNetworksFirewallStatusResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<PaloAltoNetworksFirewallStatusResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _paloAltoNetworksFirewallStatusFirewallStatusClientDiagnostics.CreateScope("PaloAltoNetworksFirewallStatusResource.Get");
            scope.Start();
            try
            {
                var response = await _paloAltoNetworksFirewallStatusFirewallStatusRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new PaloAltoNetworksFirewallStatusResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a FirewallStatusResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/PaloAltoNetworks.Cloudngfw/firewalls/{firewallName}/statuses/default</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>FirewallStatus_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="PaloAltoNetworksFirewallStatusResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<PaloAltoNetworksFirewallStatusResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _paloAltoNetworksFirewallStatusFirewallStatusClientDiagnostics.CreateScope("PaloAltoNetworksFirewallStatusResource.Get");
            scope.Start();
            try
            {
                var response = _paloAltoNetworksFirewallStatusFirewallStatusRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new PaloAltoNetworksFirewallStatusResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
