// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.PaloAltoNetworks.Ngfw.Models;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw
{
    /// <summary>
    /// A class representing the PaloAltoNetworksFirewallStatus data model.
    /// Firewall Status
    /// </summary>
    public partial class PaloAltoNetworksFirewallStatusData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PaloAltoNetworksFirewallStatusData"/>. </summary>
        public PaloAltoNetworksFirewallStatusData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PaloAltoNetworksFirewallStatusData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="isPanoramaManaged"> Panorama Managed: Default is False. Default will be CloudSec managed. </param>
        /// <param name="healthStatus"> Current status of the Firewall. </param>
        /// <param name="healthReason"> Detail description of current health of the Firewall. </param>
        /// <param name="panoramaStatus"> Panorama Status. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PaloAltoNetworksFirewallStatusData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, FirewallBooleanType? isPanoramaManaged, FirewallHealthStatus? healthStatus, string healthReason, FirewallPanoramaStatus panoramaStatus, FirewallProvisioningStateType? provisioningState, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            IsPanoramaManaged = isPanoramaManaged;
            HealthStatus = healthStatus;
            HealthReason = healthReason;
            PanoramaStatus = panoramaStatus;
            ProvisioningState = provisioningState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Panorama Managed: Default is False. Default will be CloudSec managed. </summary>
        public FirewallBooleanType? IsPanoramaManaged { get; }
        /// <summary> Current status of the Firewall. </summary>
        public FirewallHealthStatus? HealthStatus { get; }
        /// <summary> Detail description of current health of the Firewall. </summary>
        public string HealthReason { get; }
        /// <summary> Panorama Status. </summary>
        public FirewallPanoramaStatus PanoramaStatus { get; }
        /// <summary> Provisioning state of the resource. </summary>
        public FirewallProvisioningStateType? ProvisioningState { get; }
    }
}
