// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.PaloAltoNetworks.Ngfw.Models;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw
{
    /// <summary>
    /// A class representing the PaloAltoNetworksFirewall data model.
    /// PaloAltoNetworks Firewall
    /// </summary>
    public partial class PaloAltoNetworksFirewallData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PaloAltoNetworksFirewallData"/>. </summary>
        /// <param name="location"> The location. </param>
        /// <param name="networkProfile"> Network settings. </param>
        /// <param name="dnsSettings"> DNS settings for Firewall. </param>
        /// <param name="planData"> Billing plan information. </param>
        /// <param name="marketplaceDetails"> Marketplace details. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="networkProfile"/>, <paramref name="dnsSettings"/>, <paramref name="planData"/> or <paramref name="marketplaceDetails"/> is null. </exception>
        public PaloAltoNetworksFirewallData(AzureLocation location, FirewallNetworkProfile networkProfile, FirewallDnsSettings dnsSettings, FirewallBillingPlanInfo planData, PanFirewallMarketplaceDetails marketplaceDetails) : base(location)
        {
            Argument.AssertNotNull(networkProfile, nameof(networkProfile));
            Argument.AssertNotNull(dnsSettings, nameof(dnsSettings));
            Argument.AssertNotNull(planData, nameof(planData));
            Argument.AssertNotNull(marketplaceDetails, nameof(marketplaceDetails));

            NetworkProfile = networkProfile;
            DnsSettings = dnsSettings;
            FrontEndSettings = new ChangeTrackingList<FirewallFrontendSetting>();
            PlanData = planData;
            MarketplaceDetails = marketplaceDetails;
        }

        /// <summary> Initializes a new instance of <see cref="PaloAltoNetworksFirewallData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="identity"> The managed service identities assigned to this resource. </param>
        /// <param name="panETag"> panEtag info. </param>
        /// <param name="networkProfile"> Network settings. </param>
        /// <param name="isPanoramaManaged"> Panorama Managed: Default is False. Default will be CloudSec managed. </param>
        /// <param name="panoramaConfig"> Panorama Configuration. </param>
        /// <param name="associatedRulestack"> Associated Rulestack. </param>
        /// <param name="dnsSettings"> DNS settings for Firewall. </param>
        /// <param name="frontEndSettings"> Frontend settings for Firewall. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <param name="planData"> Billing plan information. </param>
        /// <param name="marketplaceDetails"> Marketplace details. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PaloAltoNetworksFirewallData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, ManagedServiceIdentity identity, ETag? panETag, FirewallNetworkProfile networkProfile, FirewallBooleanType? isPanoramaManaged, FirewallPanoramaConfiguration panoramaConfig, RulestackDetails associatedRulestack, FirewallDnsSettings dnsSettings, IList<FirewallFrontendSetting> frontEndSettings, FirewallProvisioningState? provisioningState, FirewallBillingPlanInfo planData, PanFirewallMarketplaceDetails marketplaceDetails, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            Identity = identity;
            PanETag = panETag;
            NetworkProfile = networkProfile;
            IsPanoramaManaged = isPanoramaManaged;
            PanoramaConfig = panoramaConfig;
            AssociatedRulestack = associatedRulestack;
            DnsSettings = dnsSettings;
            FrontEndSettings = frontEndSettings;
            ProvisioningState = provisioningState;
            PlanData = planData;
            MarketplaceDetails = marketplaceDetails;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="PaloAltoNetworksFirewallData"/> for deserialization. </summary>
        internal PaloAltoNetworksFirewallData()
        {
        }

        /// <summary> The managed service identities assigned to this resource. </summary>
        public ManagedServiceIdentity Identity { get; set; }
        /// <summary> panEtag info. </summary>
        public ETag? PanETag { get; set; }
        /// <summary> Network settings. </summary>
        public FirewallNetworkProfile NetworkProfile { get; set; }
        /// <summary> Panorama Managed: Default is False. Default will be CloudSec managed. </summary>
        public FirewallBooleanType? IsPanoramaManaged { get; set; }
        /// <summary> Panorama Configuration. </summary>
        public FirewallPanoramaConfiguration PanoramaConfig { get; set; }
        /// <summary> Associated Rulestack. </summary>
        public RulestackDetails AssociatedRulestack { get; set; }
        /// <summary> DNS settings for Firewall. </summary>
        public FirewallDnsSettings DnsSettings { get; set; }
        /// <summary> Frontend settings for Firewall. </summary>
        public IList<FirewallFrontendSetting> FrontEndSettings { get; }
        /// <summary> Provisioning state of the resource. </summary>
        public FirewallProvisioningState? ProvisioningState { get; }
        /// <summary> Billing plan information. </summary>
        public FirewallBillingPlanInfo PlanData { get; set; }
        /// <summary> Marketplace details. </summary>
        public PanFirewallMarketplaceDetails MarketplaceDetails { get; set; }
    }
}
