// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw.Models
{
    /// <summary> Address properties. </summary>
    public partial class SourceAddressInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SourceAddressInfo"/>. </summary>
        public SourceAddressInfo()
        {
            Cidrs = new ChangeTrackingList<string>();
            Countries = new ChangeTrackingList<string>();
            Feeds = new ChangeTrackingList<string>();
            PrefixLists = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="SourceAddressInfo"/>. </summary>
        /// <param name="cidrs"> special value 'any'. </param>
        /// <param name="countries"> list of countries. </param>
        /// <param name="feeds"> list of feeds. </param>
        /// <param name="prefixLists"> prefix list. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SourceAddressInfo(IList<string> cidrs, IList<string> countries, IList<string> feeds, IList<string> prefixLists, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Cidrs = cidrs;
            Countries = countries;
            Feeds = feeds;
            PrefixLists = prefixLists;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> special value 'any'. </summary>
        public IList<string> Cidrs { get; }
        /// <summary> list of countries. </summary>
        public IList<string> Countries { get; }
        /// <summary> list of feeds. </summary>
        public IList<string> Feeds { get; }
        /// <summary> prefix list. </summary>
        public IList<string> PrefixLists { get; }
    }
}
