// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw.Models
{
    /// <summary> Enabled or Disabled Enum. </summary>
    public readonly partial struct RulestackStateType : IEquatable<RulestackStateType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RulestackStateType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RulestackStateType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DisabledValue = "DISABLED";
        private const string EnabledValue = "ENABLED";

        /// <summary> DISABLED. </summary>
        public static RulestackStateType Disabled { get; } = new RulestackStateType(DisabledValue);
        /// <summary> ENABLED. </summary>
        public static RulestackStateType Enabled { get; } = new RulestackStateType(EnabledValue);
        /// <summary> Determines if two <see cref="RulestackStateType"/> values are the same. </summary>
        public static bool operator ==(RulestackStateType left, RulestackStateType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RulestackStateType"/> values are not the same. </summary>
        public static bool operator !=(RulestackStateType left, RulestackStateType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RulestackStateType"/>. </summary>
        public static implicit operator RulestackStateType(string value) => new RulestackStateType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RulestackStateType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RulestackStateType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
