// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw.Models
{
    /// <summary> security services. </summary>
    public partial class RulestackSecurityServices
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RulestackSecurityServices"/>. </summary>
        public RulestackSecurityServices()
        {
        }

        /// <summary> Initializes a new instance of <see cref="RulestackSecurityServices"/>. </summary>
        /// <param name="vulnerabilityProfile"> IPs Vulnerability Profile Data. </param>
        /// <param name="antiSpywareProfile"> Anti spyware Profile data. </param>
        /// <param name="antiVirusProfile"> anti virus profile data. </param>
        /// <param name="urlFilteringProfile"> URL filtering profile data. </param>
        /// <param name="fileBlockingProfile"> File blocking profile data. </param>
        /// <param name="dnsSubscription"> DNS Subscription profile data. </param>
        /// <param name="outboundUnTrustCertificate"> Untrusted Egress Decryption profile data. </param>
        /// <param name="outboundTrustCertificate"> Trusted Egress Decryption profile data. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RulestackSecurityServices(string vulnerabilityProfile, string antiSpywareProfile, string antiVirusProfile, string urlFilteringProfile, string fileBlockingProfile, string dnsSubscription, string outboundUnTrustCertificate, string outboundTrustCertificate, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            VulnerabilityProfile = vulnerabilityProfile;
            AntiSpywareProfile = antiSpywareProfile;
            AntiVirusProfile = antiVirusProfile;
            UrlFilteringProfile = urlFilteringProfile;
            FileBlockingProfile = fileBlockingProfile;
            DnsSubscription = dnsSubscription;
            OutboundUnTrustCertificate = outboundUnTrustCertificate;
            OutboundTrustCertificate = outboundTrustCertificate;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> IPs Vulnerability Profile Data. </summary>
        public string VulnerabilityProfile { get; set; }
        /// <summary> Anti spyware Profile data. </summary>
        public string AntiSpywareProfile { get; set; }
        /// <summary> anti virus profile data. </summary>
        public string AntiVirusProfile { get; set; }
        /// <summary> URL filtering profile data. </summary>
        public string UrlFilteringProfile { get; set; }
        /// <summary> File blocking profile data. </summary>
        public string FileBlockingProfile { get; set; }
        /// <summary> DNS Subscription profile data. </summary>
        public string DnsSubscription { get; set; }
        /// <summary> Untrusted Egress Decryption profile data. </summary>
        public string OutboundUnTrustCertificate { get; set; }
        /// <summary> Trusted Egress Decryption profile data. </summary>
        public string OutboundTrustCertificate { get; set; }
    }
}
