// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw.Models
{
    public partial class RulestackSecurityServiceTypeList : IUtf8JsonSerializable, IJsonModel<RulestackSecurityServiceTypeList>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<RulestackSecurityServiceTypeList>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<RulestackSecurityServiceTypeList>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RulestackSecurityServiceTypeList>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RulestackSecurityServiceTypeList)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(SecurityServicesTypeListType))
            {
                writer.WritePropertyName("type"u8);
                writer.WriteStringValue(SecurityServicesTypeListType);
            }
            writer.WritePropertyName("entry"u8);
            writer.WriteStartArray();
            foreach (var item in Entry)
            {
                writer.WriteObjectValue(item, options);
            }
            writer.WriteEndArray();
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        RulestackSecurityServiceTypeList IJsonModel<RulestackSecurityServiceTypeList>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RulestackSecurityServiceTypeList>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RulestackSecurityServiceTypeList)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeRulestackSecurityServiceTypeList(document.RootElement, options);
        }

        internal static RulestackSecurityServiceTypeList DeserializeRulestackSecurityServiceTypeList(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string type = default;
            IReadOnlyList<NameDescriptionObject> entry = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("type"u8))
                {
                    type = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("entry"u8))
                {
                    List<NameDescriptionObject> array = new List<NameDescriptionObject>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(NameDescriptionObject.DeserializeNameDescriptionObject(item, options));
                    }
                    entry = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new RulestackSecurityServiceTypeList(type, entry, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<RulestackSecurityServiceTypeList>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RulestackSecurityServiceTypeList>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(RulestackSecurityServiceTypeList)} does not support writing '{options.Format}' format.");
            }
        }

        RulestackSecurityServiceTypeList IPersistableModel<RulestackSecurityServiceTypeList>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RulestackSecurityServiceTypeList>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeRulestackSecurityServiceTypeList(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(RulestackSecurityServiceTypeList)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<RulestackSecurityServiceTypeList>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
