// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw.Models
{
    /// <summary> Rulestack Type. </summary>
    public readonly partial struct RulestackScopeType : IEquatable<RulestackScopeType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RulestackScopeType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RulestackScopeType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LocalValue = "LOCAL";
        private const string GlobalValue = "GLOBAL";

        /// <summary> LOCAL. </summary>
        public static RulestackScopeType Local { get; } = new RulestackScopeType(LocalValue);
        /// <summary> GLOBAL. </summary>
        public static RulestackScopeType Global { get; } = new RulestackScopeType(GlobalValue);
        /// <summary> Determines if two <see cref="RulestackScopeType"/> values are the same. </summary>
        public static bool operator ==(RulestackScopeType left, RulestackScopeType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RulestackScopeType"/> values are not the same. </summary>
        public static bool operator !=(RulestackScopeType left, RulestackScopeType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RulestackScopeType"/>. </summary>
        public static implicit operator RulestackScopeType(string value) => new RulestackScopeType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RulestackScopeType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RulestackScopeType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
