// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw.Models
{
    /// <summary> The RulestackActionType. </summary>
    public readonly partial struct RulestackActionType : IEquatable<RulestackActionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RulestackActionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RulestackActionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AllowValue = "Allow";
        private const string DenySilentValue = "DenySilent";
        private const string DenyResetServerValue = "DenyResetServer";
        private const string DenyResetBothValue = "DenyResetBoth";

        /// <summary> Allow. </summary>
        public static RulestackActionType Allow { get; } = new RulestackActionType(AllowValue);
        /// <summary> DenySilent. </summary>
        public static RulestackActionType DenySilent { get; } = new RulestackActionType(DenySilentValue);
        /// <summary> DenyResetServer. </summary>
        public static RulestackActionType DenyResetServer { get; } = new RulestackActionType(DenyResetServerValue);
        /// <summary> DenyResetBoth. </summary>
        public static RulestackActionType DenyResetBoth { get; } = new RulestackActionType(DenyResetBothValue);
        /// <summary> Determines if two <see cref="RulestackActionType"/> values are the same. </summary>
        public static bool operator ==(RulestackActionType left, RulestackActionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RulestackActionType"/> values are not the same. </summary>
        public static bool operator !=(RulestackActionType left, RulestackActionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RulestackActionType"/>. </summary>
        public static implicit operator RulestackActionType(string value) => new RulestackActionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RulestackActionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RulestackActionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
