// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw.Models
{
    /// <summary> PAN Rulestack Describe Object. </summary>
    public partial class GlobalRulestackInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="GlobalRulestackInfo"/>. </summary>
        /// <param name="azureId"> rulestack description. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="azureId"/> is null. </exception>
        internal GlobalRulestackInfo(string azureId)
        {
            Argument.AssertNotNull(azureId, nameof(azureId));

            AzureId = azureId;
        }

        /// <summary> Initializes a new instance of <see cref="GlobalRulestackInfo"/>. </summary>
        /// <param name="azureId"> rulestack description. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal GlobalRulestackInfo(string azureId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AzureId = azureId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="GlobalRulestackInfo"/> for deserialization. </summary>
        internal GlobalRulestackInfo()
        {
        }

        /// <summary> rulestack description. </summary>
        public string AzureId { get; }
    }
}
