// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw.Models
{
    /// <summary> VnetInfo for Firewall Networking. </summary>
    public partial class FirewallVnetConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="FirewallVnetConfiguration"/>. </summary>
        /// <param name="vnet"> Azure Virtual Network. </param>
        /// <param name="trustSubnet"> Trust Subnet. </param>
        /// <param name="unTrustSubnet"> Untrust Subnet. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="vnet"/>, <paramref name="trustSubnet"/> or <paramref name="unTrustSubnet"/> is null. </exception>
        public FirewallVnetConfiguration(IPAddressSpaceInfo vnet, IPAddressSpaceInfo trustSubnet, IPAddressSpaceInfo unTrustSubnet)
        {
            Argument.AssertNotNull(vnet, nameof(vnet));
            Argument.AssertNotNull(trustSubnet, nameof(trustSubnet));
            Argument.AssertNotNull(unTrustSubnet, nameof(unTrustSubnet));

            Vnet = vnet;
            TrustSubnet = trustSubnet;
            UnTrustSubnet = unTrustSubnet;
        }

        /// <summary> Initializes a new instance of <see cref="FirewallVnetConfiguration"/>. </summary>
        /// <param name="vnet"> Azure Virtual Network. </param>
        /// <param name="trustSubnet"> Trust Subnet. </param>
        /// <param name="unTrustSubnet"> Untrust Subnet. </param>
        /// <param name="ipOfTrustSubnetForUdr"> IP of trust subnet for UDR. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal FirewallVnetConfiguration(IPAddressSpaceInfo vnet, IPAddressSpaceInfo trustSubnet, IPAddressSpaceInfo unTrustSubnet, IPAddressInfo ipOfTrustSubnetForUdr, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Vnet = vnet;
            TrustSubnet = trustSubnet;
            UnTrustSubnet = unTrustSubnet;
            IPOfTrustSubnetForUdr = ipOfTrustSubnetForUdr;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="FirewallVnetConfiguration"/> for deserialization. </summary>
        internal FirewallVnetConfiguration()
        {
        }

        /// <summary> Azure Virtual Network. </summary>
        public IPAddressSpaceInfo Vnet { get; set; }
        /// <summary> Trust Subnet. </summary>
        public IPAddressSpaceInfo TrustSubnet { get; set; }
        /// <summary> Untrust Subnet. </summary>
        public IPAddressSpaceInfo UnTrustSubnet { get; set; }
        /// <summary> IP of trust subnet for UDR. </summary>
        public IPAddressInfo IPOfTrustSubnetForUdr { get; set; }
    }
}
