// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw.Models
{
    /// <summary> Support information for the resource. </summary>
    public partial class FirewallSupportInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="FirewallSupportInfo"/>. </summary>
        internal FirewallSupportInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="FirewallSupportInfo"/>. </summary>
        /// <param name="productSku"> product SKU associated with given resource. </param>
        /// <param name="productSerial"> product Serial associated with given resource. </param>
        /// <param name="accountRegistered"> account registered in Customer Support Portal. </param>
        /// <param name="accountId"> Support account associated with given resource. </param>
        /// <param name="userDomainSupported"> user domain is supported in Customer Support Portal. </param>
        /// <param name="userRegistered"> user registered in Customer Support Portal. </param>
        /// <param name="freeTrial"> Product usage is in free trial period. </param>
        /// <param name="freeTrialDaysLeft"> Free trial days remaining. </param>
        /// <param name="freeTrialCreditLeft"> Free trial credit remaining. </param>
        /// <param name="helpURL"> URL for paloaltonetworks live community. </param>
        /// <param name="supportURL"> URL for paloaltonetworks Customer Service Portal. </param>
        /// <param name="registerURL"> URL for registering product in paloaltonetworks Customer Service Portal. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal FirewallSupportInfo(string productSku, string productSerial, FirewallBooleanType? accountRegistered, string accountId, FirewallBooleanType? userDomainSupported, FirewallBooleanType? userRegistered, FirewallBooleanType? freeTrial, int? freeTrialDaysLeft, int? freeTrialCreditLeft, string helpURL, string supportURL, string registerURL, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProductSku = productSku;
            ProductSerial = productSerial;
            AccountRegistered = accountRegistered;
            AccountId = accountId;
            UserDomainSupported = userDomainSupported;
            UserRegistered = userRegistered;
            FreeTrial = freeTrial;
            FreeTrialDaysLeft = freeTrialDaysLeft;
            FreeTrialCreditLeft = freeTrialCreditLeft;
            HelpURL = helpURL;
            SupportURL = supportURL;
            RegisterURL = registerURL;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> product SKU associated with given resource. </summary>
        public string ProductSku { get; }
        /// <summary> product Serial associated with given resource. </summary>
        public string ProductSerial { get; }
        /// <summary> account registered in Customer Support Portal. </summary>
        public FirewallBooleanType? AccountRegistered { get; }
        /// <summary> Support account associated with given resource. </summary>
        public string AccountId { get; }
        /// <summary> user domain is supported in Customer Support Portal. </summary>
        public FirewallBooleanType? UserDomainSupported { get; }
        /// <summary> user registered in Customer Support Portal. </summary>
        public FirewallBooleanType? UserRegistered { get; }
        /// <summary> Product usage is in free trial period. </summary>
        public FirewallBooleanType? FreeTrial { get; }
        /// <summary> Free trial days remaining. </summary>
        public int? FreeTrialDaysLeft { get; }
        /// <summary> Free trial credit remaining. </summary>
        public int? FreeTrialCreditLeft { get; }
        /// <summary> URL for paloaltonetworks live community. </summary>
        public string HelpURL { get; }
        /// <summary> URL for paloaltonetworks Customer Service Portal. </summary>
        public string SupportURL { get; }
        /// <summary> URL for registering product in paloaltonetworks Customer Service Portal. </summary>
        public string RegisterURL { get; }
    }
}
