// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw.Models
{
    public partial class FirewallRuleResetConter : IUtf8JsonSerializable, IJsonModel<FirewallRuleResetConter>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<FirewallRuleResetConter>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<FirewallRuleResetConter>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FirewallRuleResetConter>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FirewallRuleResetConter)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(Priority))
            {
                writer.WritePropertyName("priority"u8);
                writer.WriteStringValue(Priority);
            }
            if (Optional.IsDefined(RuleStackName))
            {
                writer.WritePropertyName("ruleStackName"u8);
                writer.WriteStringValue(RuleStackName);
            }
            if (Optional.IsDefined(RuleListName))
            {
                writer.WritePropertyName("ruleListName"u8);
                writer.WriteStringValue(RuleListName);
            }
            if (Optional.IsDefined(FirewallName))
            {
                writer.WritePropertyName("firewallName"u8);
                writer.WriteStringValue(FirewallName);
            }
            if (Optional.IsDefined(RuleName))
            {
                writer.WritePropertyName("ruleName"u8);
                writer.WriteStringValue(RuleName);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        FirewallRuleResetConter IJsonModel<FirewallRuleResetConter>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FirewallRuleResetConter>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FirewallRuleResetConter)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeFirewallRuleResetConter(document.RootElement, options);
        }

        internal static FirewallRuleResetConter DeserializeFirewallRuleResetConter(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string priority = default;
            string ruleStackName = default;
            string ruleListName = default;
            string firewallName = default;
            string ruleName = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("priority"u8))
                {
                    priority = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("ruleStackName"u8))
                {
                    ruleStackName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("ruleListName"u8))
                {
                    ruleListName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("firewallName"u8))
                {
                    firewallName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("ruleName"u8))
                {
                    ruleName = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new FirewallRuleResetConter(
                priority,
                ruleStackName,
                ruleListName,
                firewallName,
                ruleName,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<FirewallRuleResetConter>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FirewallRuleResetConter>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(FirewallRuleResetConter)} does not support writing '{options.Format}' format.");
            }
        }

        FirewallRuleResetConter IPersistableModel<FirewallRuleResetConter>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FirewallRuleResetConter>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeFirewallRuleResetConter(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(FirewallRuleResetConter)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<FirewallRuleResetConter>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
