// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw.Models
{
    /// <summary> Rule counter. </summary>
    public partial class FirewallRuleCounter
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="FirewallRuleCounter"/>. </summary>
        /// <param name="priority"> priority number. </param>
        /// <param name="ruleName"> rule name. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="priority"/> or <paramref name="ruleName"/> is null. </exception>
        internal FirewallRuleCounter(string priority, string ruleName)
        {
            Argument.AssertNotNull(priority, nameof(priority));
            Argument.AssertNotNull(ruleName, nameof(ruleName));

            Priority = priority;
            RuleName = ruleName;
        }

        /// <summary> Initializes a new instance of <see cref="FirewallRuleCounter"/>. </summary>
        /// <param name="priority"> priority number. </param>
        /// <param name="ruleStackName"> rule Stack Name. </param>
        /// <param name="ruleListName"> rule list name. </param>
        /// <param name="firewallName"> firewall name. </param>
        /// <param name="ruleName"> rule name. </param>
        /// <param name="hitCount"> hit count. </param>
        /// <param name="appSeen"> apps seen. </param>
        /// <param name="responseOn"> timestamp of response. </param>
        /// <param name="requestOn"> timestamp of request. </param>
        /// <param name="lastUpdatedOn"> last updated timestamp. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal FirewallRuleCounter(string priority, string ruleStackName, string ruleListName, string firewallName, string ruleName, int? hitCount, AppSeenInfoList appSeen, DateTimeOffset? responseOn, DateTimeOffset? requestOn, DateTimeOffset? lastUpdatedOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Priority = priority;
            RuleStackName = ruleStackName;
            RuleListName = ruleListName;
            FirewallName = firewallName;
            RuleName = ruleName;
            HitCount = hitCount;
            AppSeen = appSeen;
            ResponseOn = responseOn;
            RequestOn = requestOn;
            LastUpdatedOn = lastUpdatedOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="FirewallRuleCounter"/> for deserialization. </summary>
        internal FirewallRuleCounter()
        {
        }

        /// <summary> priority number. </summary>
        public string Priority { get; }
        /// <summary> rule Stack Name. </summary>
        public string RuleStackName { get; }
        /// <summary> rule list name. </summary>
        public string RuleListName { get; }
        /// <summary> firewall name. </summary>
        public string FirewallName { get; }
        /// <summary> rule name. </summary>
        public string RuleName { get; }
        /// <summary> hit count. </summary>
        public int? HitCount { get; }
        /// <summary> apps seen. </summary>
        public AppSeenInfoList AppSeen { get; }
        /// <summary> timestamp of response. </summary>
        public DateTimeOffset? ResponseOn { get; }
        /// <summary> timestamp of request. </summary>
        public DateTimeOffset? RequestOn { get; }
        /// <summary> last updated timestamp. </summary>
        public DateTimeOffset? LastUpdatedOn { get; }
    }
}
