// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw.Models
{
    /// <summary> Provisioning state of the firewall resource. </summary>
    public readonly partial struct FirewallProvisioningStateType : IEquatable<FirewallProvisioningStateType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FirewallProvisioningStateType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FirewallProvisioningStateType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string DeletedValue = "Deleted";

        /// <summary> Succeeded. </summary>
        public static FirewallProvisioningStateType Succeeded { get; } = new FirewallProvisioningStateType(SucceededValue);
        /// <summary> Failed. </summary>
        public static FirewallProvisioningStateType Failed { get; } = new FirewallProvisioningStateType(FailedValue);
        /// <summary> Deleted. </summary>
        public static FirewallProvisioningStateType Deleted { get; } = new FirewallProvisioningStateType(DeletedValue);
        /// <summary> Determines if two <see cref="FirewallProvisioningStateType"/> values are the same. </summary>
        public static bool operator ==(FirewallProvisioningStateType left, FirewallProvisioningStateType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FirewallProvisioningStateType"/> values are not the same. </summary>
        public static bool operator !=(FirewallProvisioningStateType left, FirewallProvisioningStateType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FirewallProvisioningStateType"/>. </summary>
        public static implicit operator FirewallProvisioningStateType(string value) => new FirewallProvisioningStateType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FirewallProvisioningStateType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FirewallProvisioningStateType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
