// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw.Models
{
    /// <summary> Provisioning state of the firewall resource. </summary>
    public readonly partial struct FirewallProvisioningState : IEquatable<FirewallProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FirewallProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FirewallProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AcceptedValue = "Accepted";
        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string DeletedValue = "Deleted";
        private const string NotSpecifiedValue = "NotSpecified";

        /// <summary> Accepted. </summary>
        public static FirewallProvisioningState Accepted { get; } = new FirewallProvisioningState(AcceptedValue);
        /// <summary> Creating. </summary>
        public static FirewallProvisioningState Creating { get; } = new FirewallProvisioningState(CreatingValue);
        /// <summary> Updating. </summary>
        public static FirewallProvisioningState Updating { get; } = new FirewallProvisioningState(UpdatingValue);
        /// <summary> Deleting. </summary>
        public static FirewallProvisioningState Deleting { get; } = new FirewallProvisioningState(DeletingValue);
        /// <summary> Succeeded. </summary>
        public static FirewallProvisioningState Succeeded { get; } = new FirewallProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static FirewallProvisioningState Failed { get; } = new FirewallProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static FirewallProvisioningState Canceled { get; } = new FirewallProvisioningState(CanceledValue);
        /// <summary> Deleted. </summary>
        public static FirewallProvisioningState Deleted { get; } = new FirewallProvisioningState(DeletedValue);
        /// <summary> NotSpecified. </summary>
        public static FirewallProvisioningState NotSpecified { get; } = new FirewallProvisioningState(NotSpecifiedValue);
        /// <summary> Determines if two <see cref="FirewallProvisioningState"/> values are the same. </summary>
        public static bool operator ==(FirewallProvisioningState left, FirewallProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FirewallProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(FirewallProvisioningState left, FirewallProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FirewallProvisioningState"/>. </summary>
        public static implicit operator FirewallProvisioningState(string value) => new FirewallProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FirewallProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FirewallProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
