// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw.Models
{
    public partial class FirewallPanoramaStatus : IUtf8JsonSerializable, IJsonModel<FirewallPanoramaStatus>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<FirewallPanoramaStatus>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<FirewallPanoramaStatus>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FirewallPanoramaStatus>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FirewallPanoramaStatus)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(PanoramaServerStatus))
            {
                writer.WritePropertyName("panoramaServerStatus"u8);
                writer.WriteStringValue(PanoramaServerStatus.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(PanoramaServer2Status))
            {
                writer.WritePropertyName("panoramaServer2Status"u8);
                writer.WriteStringValue(PanoramaServer2Status.Value.ToString());
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        FirewallPanoramaStatus IJsonModel<FirewallPanoramaStatus>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FirewallPanoramaStatus>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FirewallPanoramaStatus)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeFirewallPanoramaStatus(document.RootElement, options);
        }

        internal static FirewallPanoramaStatus DeserializeFirewallPanoramaStatus(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            FirewallPanoramaServerStatus? panoramaServerStatus = default;
            FirewallPanoramaServerStatus? panoramaServer2Status = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("panoramaServerStatus"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    panoramaServerStatus = new FirewallPanoramaServerStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("panoramaServer2Status"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    panoramaServer2Status = new FirewallPanoramaServerStatus(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new FirewallPanoramaStatus(panoramaServerStatus, panoramaServer2Status, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<FirewallPanoramaStatus>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FirewallPanoramaStatus>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(FirewallPanoramaStatus)} does not support writing '{options.Format}' format.");
            }
        }

        FirewallPanoramaStatus IPersistableModel<FirewallPanoramaStatus>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FirewallPanoramaStatus>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeFirewallPanoramaStatus(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(FirewallPanoramaStatus)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<FirewallPanoramaStatus>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
