// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw.Models
{
    /// <summary> Connectivity Status for Panorama Server. </summary>
    public readonly partial struct FirewallPanoramaServerStatus : IEquatable<FirewallPanoramaServerStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FirewallPanoramaServerStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FirewallPanoramaServerStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UpValue = "UP";
        private const string DownValue = "DOWN";

        /// <summary> UP. </summary>
        public static FirewallPanoramaServerStatus Up { get; } = new FirewallPanoramaServerStatus(UpValue);
        /// <summary> DOWN. </summary>
        public static FirewallPanoramaServerStatus Down { get; } = new FirewallPanoramaServerStatus(DownValue);
        /// <summary> Determines if two <see cref="FirewallPanoramaServerStatus"/> values are the same. </summary>
        public static bool operator ==(FirewallPanoramaServerStatus left, FirewallPanoramaServerStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FirewallPanoramaServerStatus"/> values are not the same. </summary>
        public static bool operator !=(FirewallPanoramaServerStatus left, FirewallPanoramaServerStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FirewallPanoramaServerStatus"/>. </summary>
        public static implicit operator FirewallPanoramaServerStatus(string value) => new FirewallPanoramaServerStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FirewallPanoramaServerStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FirewallPanoramaServerStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
