// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw.Models
{
    public partial class FirewallPanoramaConfiguration : IUtf8JsonSerializable, IJsonModel<FirewallPanoramaConfiguration>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<FirewallPanoramaConfiguration>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<FirewallPanoramaConfiguration>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FirewallPanoramaConfiguration>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FirewallPanoramaConfiguration)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("configString"u8);
            writer.WriteStringValue(ConfigString);
            if (options.Format != "W" && Optional.IsDefined(VmAuthKey))
            {
                writer.WritePropertyName("vmAuthKey"u8);
                writer.WriteStringValue(VmAuthKey);
            }
            if (options.Format != "W" && Optional.IsDefined(PanoramaServer))
            {
                writer.WritePropertyName("panoramaServer"u8);
                writer.WriteStringValue(PanoramaServer);
            }
            if (options.Format != "W" && Optional.IsDefined(PanoramaServer2))
            {
                writer.WritePropertyName("panoramaServer2"u8);
                writer.WriteStringValue(PanoramaServer2);
            }
            if (options.Format != "W" && Optional.IsDefined(DgName))
            {
                writer.WritePropertyName("dgName"u8);
                writer.WriteStringValue(DgName);
            }
            if (options.Format != "W" && Optional.IsDefined(TplName))
            {
                writer.WritePropertyName("tplName"u8);
                writer.WriteStringValue(TplName);
            }
            if (options.Format != "W" && Optional.IsDefined(CgName))
            {
                writer.WritePropertyName("cgName"u8);
                writer.WriteStringValue(CgName);
            }
            if (options.Format != "W" && Optional.IsDefined(HostName))
            {
                writer.WritePropertyName("hostName"u8);
                writer.WriteStringValue(HostName);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        FirewallPanoramaConfiguration IJsonModel<FirewallPanoramaConfiguration>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FirewallPanoramaConfiguration>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FirewallPanoramaConfiguration)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeFirewallPanoramaConfiguration(document.RootElement, options);
        }

        internal static FirewallPanoramaConfiguration DeserializeFirewallPanoramaConfiguration(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string configString = default;
            string vmAuthKey = default;
            string panoramaServer = default;
            string panoramaServer2 = default;
            string dgName = default;
            string tplName = default;
            string cgName = default;
            string hostName = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("configString"u8))
                {
                    configString = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("vmAuthKey"u8))
                {
                    vmAuthKey = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("panoramaServer"u8))
                {
                    panoramaServer = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("panoramaServer2"u8))
                {
                    panoramaServer2 = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("dgName"u8))
                {
                    dgName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("tplName"u8))
                {
                    tplName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("cgName"u8))
                {
                    cgName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("hostName"u8))
                {
                    hostName = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new FirewallPanoramaConfiguration(
                configString,
                vmAuthKey,
                panoramaServer,
                panoramaServer2,
                dgName,
                tplName,
                cgName,
                hostName,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<FirewallPanoramaConfiguration>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FirewallPanoramaConfiguration>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(FirewallPanoramaConfiguration)} does not support writing '{options.Format}' format.");
            }
        }

        FirewallPanoramaConfiguration IPersistableModel<FirewallPanoramaConfiguration>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FirewallPanoramaConfiguration>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeFirewallPanoramaConfiguration(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(FirewallPanoramaConfiguration)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<FirewallPanoramaConfiguration>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
