// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw.Models
{
    /// <summary> NetworkType Enum. </summary>
    public readonly partial struct FirewallNetworkType : IEquatable<FirewallNetworkType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FirewallNetworkType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FirewallNetworkType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string VnetValue = "VNET";
        private const string VwanValue = "VWAN";

        /// <summary> VNET. </summary>
        public static FirewallNetworkType Vnet { get; } = new FirewallNetworkType(VnetValue);
        /// <summary> VWAN. </summary>
        public static FirewallNetworkType Vwan { get; } = new FirewallNetworkType(VwanValue);
        /// <summary> Determines if two <see cref="FirewallNetworkType"/> values are the same. </summary>
        public static bool operator ==(FirewallNetworkType left, FirewallNetworkType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FirewallNetworkType"/> values are not the same. </summary>
        public static bool operator !=(FirewallNetworkType left, FirewallNetworkType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FirewallNetworkType"/>. </summary>
        public static implicit operator FirewallNetworkType(string value) => new FirewallNetworkType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FirewallNetworkType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FirewallNetworkType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
