// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw.Models
{
    /// <summary> Possible log types. </summary>
    public readonly partial struct FirewallLogType : IEquatable<FirewallLogType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FirewallLogType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FirewallLogType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TrafficValue = "TRAFFIC";
        private const string ThreatValue = "THREAT";
        private const string DecryptionValue = "DECRYPTION";
        private const string WildfireValue = "WILDFIRE";
        private const string DlpValue = "DLP";
        private const string AuditValue = "AUDIT";

        /// <summary> TRAFFIC. </summary>
        public static FirewallLogType Traffic { get; } = new FirewallLogType(TrafficValue);
        /// <summary> THREAT. </summary>
        public static FirewallLogType Threat { get; } = new FirewallLogType(ThreatValue);
        /// <summary> DECRYPTION. </summary>
        public static FirewallLogType Decryption { get; } = new FirewallLogType(DecryptionValue);
        /// <summary> WILDFIRE. </summary>
        public static FirewallLogType Wildfire { get; } = new FirewallLogType(WildfireValue);
        /// <summary> DLP. </summary>
        public static FirewallLogType Dlp { get; } = new FirewallLogType(DlpValue);
        /// <summary> AUDIT. </summary>
        public static FirewallLogType Audit { get; } = new FirewallLogType(AuditValue);
        /// <summary> Determines if two <see cref="FirewallLogType"/> values are the same. </summary>
        public static bool operator ==(FirewallLogType left, FirewallLogType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FirewallLogType"/> values are not the same. </summary>
        public static bool operator !=(FirewallLogType left, FirewallLogType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FirewallLogType"/>. </summary>
        public static implicit operator FirewallLogType(string value) => new FirewallLogType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FirewallLogType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FirewallLogType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
