// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw.Models
{
    /// <summary> Log options possible. </summary>
    public readonly partial struct FirewallLogOption : IEquatable<FirewallLogOption>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FirewallLogOption"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FirewallLogOption(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SameDestinationValue = "SAME_DESTINATION";
        private const string IndividualDestinationValue = "INDIVIDUAL_DESTINATION";

        /// <summary> SAME_DESTINATION. </summary>
        public static FirewallLogOption SameDestination { get; } = new FirewallLogOption(SameDestinationValue);
        /// <summary> INDIVIDUAL_DESTINATION. </summary>
        public static FirewallLogOption IndividualDestination { get; } = new FirewallLogOption(IndividualDestinationValue);
        /// <summary> Determines if two <see cref="FirewallLogOption"/> values are the same. </summary>
        public static bool operator ==(FirewallLogOption left, FirewallLogOption right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FirewallLogOption"/> values are not the same. </summary>
        public static bool operator !=(FirewallLogOption left, FirewallLogOption right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FirewallLogOption"/>. </summary>
        public static implicit operator FirewallLogOption(string value) => new FirewallLogOption(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FirewallLogOption other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FirewallLogOption other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
