// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw.Models
{
    /// <summary> Log Destination. </summary>
    public partial class FirewallLogDestination
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="FirewallLogDestination"/>. </summary>
        public FirewallLogDestination()
        {
        }

        /// <summary> Initializes a new instance of <see cref="FirewallLogDestination"/>. </summary>
        /// <param name="storageConfiguration"> Storage account configurations. </param>
        /// <param name="eventHubConfiguration"> Event Hub configurations. </param>
        /// <param name="monitorConfiguration"> Monitor Log configurations. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal FirewallLogDestination(StorageAccountConfiguration storageConfiguration, EventHubConfiguration eventHubConfiguration, MonitorLogConfiguration monitorConfiguration, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            StorageConfiguration = storageConfiguration;
            EventHubConfiguration = eventHubConfiguration;
            MonitorConfiguration = monitorConfiguration;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Storage account configurations. </summary>
        public StorageAccountConfiguration StorageConfiguration { get; set; }
        /// <summary> Event Hub configurations. </summary>
        public EventHubConfiguration EventHubConfiguration { get; set; }
        /// <summary> Monitor Log configurations. </summary>
        public MonitorLogConfiguration MonitorConfiguration { get; set; }
    }
}
