// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw.Models
{
    /// <summary> Boolean Enum. </summary>
    public readonly partial struct FirewallBooleanType : IEquatable<FirewallBooleanType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FirewallBooleanType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FirewallBooleanType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TrueValue = "TRUE";
        private const string FalseValue = "FALSE";

        /// <summary> TRUE. </summary>
        public static FirewallBooleanType True { get; } = new FirewallBooleanType(TrueValue);
        /// <summary> FALSE. </summary>
        public static FirewallBooleanType False { get; } = new FirewallBooleanType(FalseValue);
        /// <summary> Determines if two <see cref="FirewallBooleanType"/> values are the same. </summary>
        public static bool operator ==(FirewallBooleanType left, FirewallBooleanType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FirewallBooleanType"/> values are not the same. </summary>
        public static bool operator !=(FirewallBooleanType left, FirewallBooleanType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FirewallBooleanType"/>. </summary>
        public static implicit operator FirewallBooleanType(string value) => new FirewallBooleanType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FirewallBooleanType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FirewallBooleanType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
