// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw.Models
{
    /// <summary> Usage Type. </summary>
    public readonly partial struct FirewallBillingPlanUsageType : IEquatable<FirewallBillingPlanUsageType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FirewallBillingPlanUsageType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FirewallBillingPlanUsageType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PaygValue = "PAYG";
        private const string CommittedValue = "COMMITTED";

        /// <summary> PAYG. </summary>
        public static FirewallBillingPlanUsageType Payg { get; } = new FirewallBillingPlanUsageType(PaygValue);
        /// <summary> COMMITTED. </summary>
        public static FirewallBillingPlanUsageType Committed { get; } = new FirewallBillingPlanUsageType(CommittedValue);
        /// <summary> Determines if two <see cref="FirewallBillingPlanUsageType"/> values are the same. </summary>
        public static bool operator ==(FirewallBillingPlanUsageType left, FirewallBillingPlanUsageType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FirewallBillingPlanUsageType"/> values are not the same. </summary>
        public static bool operator !=(FirewallBillingPlanUsageType left, FirewallBillingPlanUsageType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FirewallBillingPlanUsageType"/>. </summary>
        public static implicit operator FirewallBillingPlanUsageType(string value) => new FirewallBillingPlanUsageType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FirewallBillingPlanUsageType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FirewallBillingPlanUsageType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
