// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw.Models
{
    /// <summary> The DecryptionRuleType. </summary>
    public readonly partial struct DecryptionRuleType : IEquatable<DecryptionRuleType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DecryptionRuleType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DecryptionRuleType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SslOutboundInspectionValue = "SSLOutboundInspection";
        private const string SslInboundInspectionValue = "SSLInboundInspection";
        private const string NoneValue = "None";

        /// <summary> SSLOutboundInspection. </summary>
        public static DecryptionRuleType SslOutboundInspection { get; } = new DecryptionRuleType(SslOutboundInspectionValue);
        /// <summary> SSLInboundInspection. </summary>
        public static DecryptionRuleType SslInboundInspection { get; } = new DecryptionRuleType(SslInboundInspectionValue);
        /// <summary> None. </summary>
        public static DecryptionRuleType None { get; } = new DecryptionRuleType(NoneValue);
        /// <summary> Determines if two <see cref="DecryptionRuleType"/> values are the same. </summary>
        public static bool operator ==(DecryptionRuleType left, DecryptionRuleType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DecryptionRuleType"/> values are not the same. </summary>
        public static bool operator !=(DecryptionRuleType left, DecryptionRuleType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DecryptionRuleType"/>. </summary>
        public static implicit operator DecryptionRuleType(string value) => new DecryptionRuleType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DecryptionRuleType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DecryptionRuleType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
