// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw.Models
{
    /// <summary> Data Type for App Seen. </summary>
    public partial class AppSeenInfoList
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AppSeenInfoList"/>. </summary>
        /// <param name="count"> number of rows. </param>
        /// <param name="appSeenList"> array of appSeen. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="appSeenList"/> is null. </exception>
        internal AppSeenInfoList(int count, IEnumerable<AppSeenInfo> appSeenList)
        {
            Argument.AssertNotNull(appSeenList, nameof(appSeenList));

            Count = count;
            AppSeenList = appSeenList.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="AppSeenInfoList"/>. </summary>
        /// <param name="count"> number of rows. </param>
        /// <param name="appSeenList"> array of appSeen. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AppSeenInfoList(int count, IReadOnlyList<AppSeenInfo> appSeenList, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Count = count;
            AppSeenList = appSeenList;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AppSeenInfoList"/> for deserialization. </summary>
        internal AppSeenInfoList()
        {
        }

        /// <summary> number of rows. </summary>
        public int Count { get; }
        /// <summary> array of appSeen. </summary>
        public IReadOnlyList<AppSeenInfo> AppSeenList { get; }
    }
}
