// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw.Models
{
    /// <summary> DNS Proxy. </summary>
    public readonly partial struct AllowDnsProxyType : IEquatable<AllowDnsProxyType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AllowDnsProxyType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AllowDnsProxyType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DisabledValue = "DISABLED";
        private const string EnabledValue = "ENABLED";

        /// <summary> DISABLED. </summary>
        public static AllowDnsProxyType Disabled { get; } = new AllowDnsProxyType(DisabledValue);
        /// <summary> ENABLED. </summary>
        public static AllowDnsProxyType Enabled { get; } = new AllowDnsProxyType(EnabledValue);
        /// <summary> Determines if two <see cref="AllowDnsProxyType"/> values are the same. </summary>
        public static bool operator ==(AllowDnsProxyType left, AllowDnsProxyType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AllowDnsProxyType"/> values are not the same. </summary>
        public static bool operator !=(AllowDnsProxyType left, AllowDnsProxyType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AllowDnsProxyType"/>. </summary>
        public static implicit operator AllowDnsProxyType(string value) => new AllowDnsProxyType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AllowDnsProxyType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AllowDnsProxyType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
