// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw.Models
{
    /// <summary> The AdvancedSecurityObjectType. </summary>
    public readonly partial struct AdvancedSecurityObjectType : IEquatable<AdvancedSecurityObjectType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AdvancedSecurityObjectType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AdvancedSecurityObjectType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UrlCustomValue = "urlCustom";
        private const string FeedsValue = "feeds";

        /// <summary> urlCustom. </summary>
        public static AdvancedSecurityObjectType UrlCustom { get; } = new AdvancedSecurityObjectType(UrlCustomValue);
        /// <summary> feeds. </summary>
        public static AdvancedSecurityObjectType Feeds { get; } = new AdvancedSecurityObjectType(FeedsValue);
        /// <summary> Determines if two <see cref="AdvancedSecurityObjectType"/> values are the same. </summary>
        public static bool operator ==(AdvancedSecurityObjectType left, AdvancedSecurityObjectType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AdvancedSecurityObjectType"/> values are not the same. </summary>
        public static bool operator !=(AdvancedSecurityObjectType left, AdvancedSecurityObjectType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AdvancedSecurityObjectType"/>. </summary>
        public static implicit operator AdvancedSecurityObjectType(string value) => new AdvancedSecurityObjectType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AdvancedSecurityObjectType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AdvancedSecurityObjectType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
