// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw.Models
{
    /// <summary> List of custom and predefined url category. </summary>
    public partial class AdvancedSecurityObject
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AdvancedSecurityObject"/>. </summary>
        /// <param name="entry"> URL entry. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="entry"/> is null. </exception>
        internal AdvancedSecurityObject(IEnumerable<NameDescriptionObject> entry)
        {
            Argument.AssertNotNull(entry, nameof(entry));

            Entry = entry.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="AdvancedSecurityObject"/>. </summary>
        /// <param name="advSecurityObjectModelType"> type of object. </param>
        /// <param name="entry"> URL entry. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AdvancedSecurityObject(string advSecurityObjectModelType, IReadOnlyList<NameDescriptionObject> entry, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AdvSecurityObjectModelType = advSecurityObjectModelType;
            Entry = entry;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AdvancedSecurityObject"/> for deserialization. </summary>
        internal AdvancedSecurityObject()
        {
        }

        /// <summary> type of object. </summary>
        public string AdvSecurityObjectModelType { get; }
        /// <summary> URL entry. </summary>
        public IReadOnlyList<NameDescriptionObject> Entry { get; }
    }
}
