// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw
{
    internal class PaloAltoNetworksFirewallOperationSource : IOperationSource<PaloAltoNetworksFirewallResource>
    {
        private readonly ArmClient _client;

        internal PaloAltoNetworksFirewallOperationSource(ArmClient client)
        {
            _client = client;
        }

        PaloAltoNetworksFirewallResource IOperationSource<PaloAltoNetworksFirewallResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = PaloAltoNetworksFirewallData.DeserializePaloAltoNetworksFirewallData(document.RootElement);
            return new PaloAltoNetworksFirewallResource(_client, data);
        }

        async ValueTask<PaloAltoNetworksFirewallResource> IOperationSource<PaloAltoNetworksFirewallResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = PaloAltoNetworksFirewallData.DeserializePaloAltoNetworksFirewallData(document.RootElement);
            return new PaloAltoNetworksFirewallResource(_client, data);
        }
    }
}
