// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw
{
    internal class LocalRulestackPrefixOperationSource : IOperationSource<LocalRulestackPrefixResource>
    {
        private readonly ArmClient _client;

        internal LocalRulestackPrefixOperationSource(ArmClient client)
        {
            _client = client;
        }

        LocalRulestackPrefixResource IOperationSource<LocalRulestackPrefixResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = LocalRulestackPrefixData.DeserializeLocalRulestackPrefixData(document.RootElement);
            return new LocalRulestackPrefixResource(_client, data);
        }

        async ValueTask<LocalRulestackPrefixResource> IOperationSource<LocalRulestackPrefixResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = LocalRulestackPrefixData.DeserializeLocalRulestackPrefixData(document.RootElement);
            return new LocalRulestackPrefixResource(_client, data);
        }
    }
}
