// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw
{
    internal class LocalRulestackOperationSource : IOperationSource<LocalRulestackResource>
    {
        private readonly ArmClient _client;

        internal LocalRulestackOperationSource(ArmClient client)
        {
            _client = client;
        }

        LocalRulestackResource IOperationSource<LocalRulestackResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = LocalRulestackData.DeserializeLocalRulestackData(document.RootElement);
            return new LocalRulestackResource(_client, data);
        }

        async ValueTask<LocalRulestackResource> IOperationSource<LocalRulestackResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = LocalRulestackData.DeserializeLocalRulestackData(document.RootElement);
            return new LocalRulestackResource(_client, data);
        }
    }
}
