// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw
{
    internal class GlobalRulestackPrefixOperationSource : IOperationSource<GlobalRulestackPrefixResource>
    {
        private readonly ArmClient _client;

        internal GlobalRulestackPrefixOperationSource(ArmClient client)
        {
            _client = client;
        }

        GlobalRulestackPrefixResource IOperationSource<GlobalRulestackPrefixResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = GlobalRulestackPrefixData.DeserializeGlobalRulestackPrefixData(document.RootElement);
            return new GlobalRulestackPrefixResource(_client, data);
        }

        async ValueTask<GlobalRulestackPrefixResource> IOperationSource<GlobalRulestackPrefixResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = GlobalRulestackPrefixData.DeserializeGlobalRulestackPrefixData(document.RootElement);
            return new GlobalRulestackPrefixResource(_client, data);
        }
    }
}
