// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw
{
    internal class GlobalRulestackOperationSource : IOperationSource<GlobalRulestackResource>
    {
        private readonly ArmClient _client;

        internal GlobalRulestackOperationSource(ArmClient client)
        {
            _client = client;
        }

        GlobalRulestackResource IOperationSource<GlobalRulestackResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = GlobalRulestackData.DeserializeGlobalRulestackData(document.RootElement);
            return new GlobalRulestackResource(_client, data);
        }

        async ValueTask<GlobalRulestackResource> IOperationSource<GlobalRulestackResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = GlobalRulestackData.DeserializeGlobalRulestackData(document.RootElement);
            return new GlobalRulestackResource(_client, data);
        }
    }
}
