// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw
{
    internal class GlobalRulestackCertificateObjectOperationSource : IOperationSource<GlobalRulestackCertificateObjectResource>
    {
        private readonly ArmClient _client;

        internal GlobalRulestackCertificateObjectOperationSource(ArmClient client)
        {
            _client = client;
        }

        GlobalRulestackCertificateObjectResource IOperationSource<GlobalRulestackCertificateObjectResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = GlobalRulestackCertificateObjectData.DeserializeGlobalRulestackCertificateObjectData(document.RootElement);
            return new GlobalRulestackCertificateObjectResource(_client, data);
        }

        async ValueTask<GlobalRulestackCertificateObjectResource> IOperationSource<GlobalRulestackCertificateObjectResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = GlobalRulestackCertificateObjectData.DeserializeGlobalRulestackCertificateObjectData(document.RootElement);
            return new GlobalRulestackCertificateObjectResource(_client, data);
        }
    }
}
