// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw
{
    /// <summary>
    /// A class representing a collection of <see cref="LocalRulestackRuleResource"/> and their operations.
    /// Each <see cref="LocalRulestackRuleResource"/> in the collection will belong to the same instance of <see cref="LocalRulestackResource"/>.
    /// To get a <see cref="LocalRulestackRuleCollection"/> instance call the GetLocalRulestackRules method from an instance of <see cref="LocalRulestackResource"/>.
    /// </summary>
    public partial class LocalRulestackRuleCollection : ArmCollection, IEnumerable<LocalRulestackRuleResource>, IAsyncEnumerable<LocalRulestackRuleResource>
    {
        private readonly ClientDiagnostics _localRulestackRuleLocalRulesClientDiagnostics;
        private readonly LocalRulesRestOperations _localRulestackRuleLocalRulesRestClient;

        /// <summary> Initializes a new instance of the <see cref="LocalRulestackRuleCollection"/> class for mocking. </summary>
        protected LocalRulestackRuleCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="LocalRulestackRuleCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal LocalRulestackRuleCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _localRulestackRuleLocalRulesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.PaloAltoNetworks.Ngfw", LocalRulestackRuleResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(LocalRulestackRuleResource.ResourceType, out string localRulestackRuleLocalRulesApiVersion);
            _localRulestackRuleLocalRulesRestClient = new LocalRulesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, localRulestackRuleLocalRulesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != LocalRulestackResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, LocalRulestackResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Create a LocalRulesResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/PaloAltoNetworks.Cloudngfw/localRulestacks/{localRulestackName}/localRules/{priority}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LocalRules_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LocalRulestackRuleResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="priority"> Local Rule priority. </param>
        /// <param name="data"> Resource create parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="priority"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="priority"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<LocalRulestackRuleResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string priority, LocalRulestackRuleData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(priority, nameof(priority));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _localRulestackRuleLocalRulesClientDiagnostics.CreateScope("LocalRulestackRuleCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _localRulestackRuleLocalRulesRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, priority, data, cancellationToken).ConfigureAwait(false);
                var operation = new NgfwArmOperation<LocalRulestackRuleResource>(new LocalRulestackRuleOperationSource(Client), _localRulestackRuleLocalRulesClientDiagnostics, Pipeline, _localRulestackRuleLocalRulesRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, priority, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Create a LocalRulesResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/PaloAltoNetworks.Cloudngfw/localRulestacks/{localRulestackName}/localRules/{priority}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LocalRules_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LocalRulestackRuleResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="priority"> Local Rule priority. </param>
        /// <param name="data"> Resource create parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="priority"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="priority"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<LocalRulestackRuleResource> CreateOrUpdate(WaitUntil waitUntil, string priority, LocalRulestackRuleData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(priority, nameof(priority));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _localRulestackRuleLocalRulesClientDiagnostics.CreateScope("LocalRulestackRuleCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _localRulestackRuleLocalRulesRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, priority, data, cancellationToken);
                var operation = new NgfwArmOperation<LocalRulestackRuleResource>(new LocalRulestackRuleOperationSource(Client), _localRulestackRuleLocalRulesClientDiagnostics, Pipeline, _localRulestackRuleLocalRulesRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, priority, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a LocalRulesResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/PaloAltoNetworks.Cloudngfw/localRulestacks/{localRulestackName}/localRules/{priority}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LocalRules_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LocalRulestackRuleResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="priority"> Local Rule priority. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="priority"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="priority"/> is null. </exception>
        public virtual async Task<Response<LocalRulestackRuleResource>> GetAsync(string priority, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(priority, nameof(priority));

            using var scope = _localRulestackRuleLocalRulesClientDiagnostics.CreateScope("LocalRulestackRuleCollection.Get");
            scope.Start();
            try
            {
                var response = await _localRulestackRuleLocalRulesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, priority, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new LocalRulestackRuleResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a LocalRulesResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/PaloAltoNetworks.Cloudngfw/localRulestacks/{localRulestackName}/localRules/{priority}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LocalRules_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LocalRulestackRuleResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="priority"> Local Rule priority. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="priority"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="priority"/> is null. </exception>
        public virtual Response<LocalRulestackRuleResource> Get(string priority, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(priority, nameof(priority));

            using var scope = _localRulestackRuleLocalRulesClientDiagnostics.CreateScope("LocalRulestackRuleCollection.Get");
            scope.Start();
            try
            {
                var response = _localRulestackRuleLocalRulesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, priority, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new LocalRulestackRuleResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// List LocalRulesResource resources by LocalRulestacks
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/PaloAltoNetworks.Cloudngfw/localRulestacks/{localRulestackName}/localRules</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LocalRules_ListByLocalRulestacks</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LocalRulestackRuleResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="LocalRulestackRuleResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<LocalRulestackRuleResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _localRulestackRuleLocalRulesRestClient.CreateListByLocalRulestacksRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _localRulestackRuleLocalRulesRestClient.CreateListByLocalRulestacksNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new LocalRulestackRuleResource(Client, LocalRulestackRuleData.DeserializeLocalRulestackRuleData(e)), _localRulestackRuleLocalRulesClientDiagnostics, Pipeline, "LocalRulestackRuleCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List LocalRulesResource resources by LocalRulestacks
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/PaloAltoNetworks.Cloudngfw/localRulestacks/{localRulestackName}/localRules</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LocalRules_ListByLocalRulestacks</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LocalRulestackRuleResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="LocalRulestackRuleResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<LocalRulestackRuleResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _localRulestackRuleLocalRulesRestClient.CreateListByLocalRulestacksRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _localRulestackRuleLocalRulesRestClient.CreateListByLocalRulestacksNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new LocalRulestackRuleResource(Client, LocalRulestackRuleData.DeserializeLocalRulestackRuleData(e)), _localRulestackRuleLocalRulesClientDiagnostics, Pipeline, "LocalRulestackRuleCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/PaloAltoNetworks.Cloudngfw/localRulestacks/{localRulestackName}/localRules/{priority}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LocalRules_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LocalRulestackRuleResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="priority"> Local Rule priority. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="priority"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="priority"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string priority, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(priority, nameof(priority));

            using var scope = _localRulestackRuleLocalRulesClientDiagnostics.CreateScope("LocalRulestackRuleCollection.Exists");
            scope.Start();
            try
            {
                var response = await _localRulestackRuleLocalRulesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, priority, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/PaloAltoNetworks.Cloudngfw/localRulestacks/{localRulestackName}/localRules/{priority}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LocalRules_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LocalRulestackRuleResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="priority"> Local Rule priority. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="priority"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="priority"/> is null. </exception>
        public virtual Response<bool> Exists(string priority, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(priority, nameof(priority));

            using var scope = _localRulestackRuleLocalRulesClientDiagnostics.CreateScope("LocalRulestackRuleCollection.Exists");
            scope.Start();
            try
            {
                var response = _localRulestackRuleLocalRulesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, priority, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/PaloAltoNetworks.Cloudngfw/localRulestacks/{localRulestackName}/localRules/{priority}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LocalRules_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LocalRulestackRuleResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="priority"> Local Rule priority. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="priority"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="priority"/> is null. </exception>
        public virtual async Task<NullableResponse<LocalRulestackRuleResource>> GetIfExistsAsync(string priority, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(priority, nameof(priority));

            using var scope = _localRulestackRuleLocalRulesClientDiagnostics.CreateScope("LocalRulestackRuleCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _localRulestackRuleLocalRulesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, priority, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<LocalRulestackRuleResource>(response.GetRawResponse());
                return Response.FromValue(new LocalRulestackRuleResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/PaloAltoNetworks.Cloudngfw/localRulestacks/{localRulestackName}/localRules/{priority}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LocalRules_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LocalRulestackRuleResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="priority"> Local Rule priority. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="priority"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="priority"/> is null. </exception>
        public virtual NullableResponse<LocalRulestackRuleResource> GetIfExists(string priority, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(priority, nameof(priority));

            using var scope = _localRulestackRuleLocalRulesClientDiagnostics.CreateScope("LocalRulestackRuleCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _localRulestackRuleLocalRulesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, priority, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<LocalRulestackRuleResource>(response.GetRawResponse());
                return Response.FromValue(new LocalRulestackRuleResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<LocalRulestackRuleResource> IEnumerable<LocalRulestackRuleResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<LocalRulestackRuleResource> IAsyncEnumerable<LocalRulestackRuleResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
