// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.PaloAltoNetworks.Ngfw.Models;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw
{
    /// <summary>
    /// A class representing the GlobalRulestackFqdn data model.
    /// GlobalRulestack fqdnList
    /// </summary>
    public partial class GlobalRulestackFqdnData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="GlobalRulestackFqdnData"/>. </summary>
        /// <param name="fqdnList"> fqdn list. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="fqdnList"/> is null. </exception>
        public GlobalRulestackFqdnData(IEnumerable<string> fqdnList)
        {
            Argument.AssertNotNull(fqdnList, nameof(fqdnList));

            FqdnList = fqdnList.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="GlobalRulestackFqdnData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="description"> fqdn object description. </param>
        /// <param name="fqdnList"> fqdn list. </param>
        /// <param name="etag"> etag info. </param>
        /// <param name="auditComment"> comment for this object. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal GlobalRulestackFqdnData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string description, IList<string> fqdnList, ETag? etag, string auditComment, FirewallProvisioningState? provisioningState, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            Description = description;
            FqdnList = fqdnList;
            ETag = etag;
            AuditComment = auditComment;
            ProvisioningState = provisioningState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="GlobalRulestackFqdnData"/> for deserialization. </summary>
        internal GlobalRulestackFqdnData()
        {
        }

        /// <summary> fqdn object description. </summary>
        public string Description { get; set; }
        /// <summary> fqdn list. </summary>
        public IList<string> FqdnList { get; }
        /// <summary> etag info. </summary>
        public ETag? ETag { get; set; }
        /// <summary> comment for this object. </summary>
        public string AuditComment { get; set; }
        /// <summary> Provisioning state of the resource. </summary>
        public FirewallProvisioningState? ProvisioningState { get; }
    }
}
