// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Threading;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw.Mocking
{
    /// <summary> A class to add extension methods to SubscriptionResource. </summary>
    public partial class MockablePaloAltoNetworksNgfwSubscriptionResource : ArmResource
    {
        private ClientDiagnostics _paloAltoNetworksFirewallFirewallsClientDiagnostics;
        private FirewallsRestOperations _paloAltoNetworksFirewallFirewallsRestClient;
        private ClientDiagnostics _localRulestackClientDiagnostics;
        private LocalRulestacksRestOperations _localRulestackRestClient;

        /// <summary> Initializes a new instance of the <see cref="MockablePaloAltoNetworksNgfwSubscriptionResource"/> class for mocking. </summary>
        protected MockablePaloAltoNetworksNgfwSubscriptionResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockablePaloAltoNetworksNgfwSubscriptionResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockablePaloAltoNetworksNgfwSubscriptionResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private ClientDiagnostics PaloAltoNetworksFirewallFirewallsClientDiagnostics => _paloAltoNetworksFirewallFirewallsClientDiagnostics ??= new ClientDiagnostics("Azure.ResourceManager.PaloAltoNetworks.Ngfw", PaloAltoNetworksFirewallResource.ResourceType.Namespace, Diagnostics);
        private FirewallsRestOperations PaloAltoNetworksFirewallFirewallsRestClient => _paloAltoNetworksFirewallFirewallsRestClient ??= new FirewallsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, GetApiVersionOrNull(PaloAltoNetworksFirewallResource.ResourceType));
        private ClientDiagnostics LocalRulestackClientDiagnostics => _localRulestackClientDiagnostics ??= new ClientDiagnostics("Azure.ResourceManager.PaloAltoNetworks.Ngfw", LocalRulestackResource.ResourceType.Namespace, Diagnostics);
        private LocalRulestacksRestOperations LocalRulestackRestClient => _localRulestackRestClient ??= new LocalRulestacksRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, GetApiVersionOrNull(LocalRulestackResource.ResourceType));

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// List FirewallResource resources by subscription ID
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/PaloAltoNetworks.Cloudngfw/firewalls</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Firewalls_ListBySubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="PaloAltoNetworksFirewallResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="PaloAltoNetworksFirewallResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<PaloAltoNetworksFirewallResource> GetPaloAltoNetworksFirewallsAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => PaloAltoNetworksFirewallFirewallsRestClient.CreateListBySubscriptionRequest(Id.SubscriptionId);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => PaloAltoNetworksFirewallFirewallsRestClient.CreateListBySubscriptionNextPageRequest(nextLink, Id.SubscriptionId);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new PaloAltoNetworksFirewallResource(Client, PaloAltoNetworksFirewallData.DeserializePaloAltoNetworksFirewallData(e)), PaloAltoNetworksFirewallFirewallsClientDiagnostics, Pipeline, "MockablePaloAltoNetworksNgfwSubscriptionResource.GetPaloAltoNetworksFirewalls", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List FirewallResource resources by subscription ID
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/PaloAltoNetworks.Cloudngfw/firewalls</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Firewalls_ListBySubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="PaloAltoNetworksFirewallResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="PaloAltoNetworksFirewallResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<PaloAltoNetworksFirewallResource> GetPaloAltoNetworksFirewalls(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => PaloAltoNetworksFirewallFirewallsRestClient.CreateListBySubscriptionRequest(Id.SubscriptionId);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => PaloAltoNetworksFirewallFirewallsRestClient.CreateListBySubscriptionNextPageRequest(nextLink, Id.SubscriptionId);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new PaloAltoNetworksFirewallResource(Client, PaloAltoNetworksFirewallData.DeserializePaloAltoNetworksFirewallData(e)), PaloAltoNetworksFirewallFirewallsClientDiagnostics, Pipeline, "MockablePaloAltoNetworksNgfwSubscriptionResource.GetPaloAltoNetworksFirewalls", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List LocalRulestackResource resources by subscription ID
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/PaloAltoNetworks.Cloudngfw/localRulestacks</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LocalRulestacks_ListBySubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LocalRulestackResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="LocalRulestackResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<LocalRulestackResource> GetLocalRulestacksAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => LocalRulestackRestClient.CreateListBySubscriptionRequest(Id.SubscriptionId);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => LocalRulestackRestClient.CreateListBySubscriptionNextPageRequest(nextLink, Id.SubscriptionId);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new LocalRulestackResource(Client, LocalRulestackData.DeserializeLocalRulestackData(e)), LocalRulestackClientDiagnostics, Pipeline, "MockablePaloAltoNetworksNgfwSubscriptionResource.GetLocalRulestacks", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List LocalRulestackResource resources by subscription ID
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/PaloAltoNetworks.Cloudngfw/localRulestacks</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LocalRulestacks_ListBySubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LocalRulestackResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="LocalRulestackResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<LocalRulestackResource> GetLocalRulestacks(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => LocalRulestackRestClient.CreateListBySubscriptionRequest(Id.SubscriptionId);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => LocalRulestackRestClient.CreateListBySubscriptionNextPageRequest(nextLink, Id.SubscriptionId);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new LocalRulestackResource(Client, LocalRulestackData.DeserializeLocalRulestackData(e)), LocalRulestackClientDiagnostics, Pipeline, "MockablePaloAltoNetworksNgfwSubscriptionResource.GetLocalRulestacks", "value", "nextLink", cancellationToken);
        }
    }
}
