// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.PaloAltoNetworks.Ngfw.Mocking
{
    /// <summary> A class to add extension methods to ResourceGroupResource. </summary>
    public partial class MockablePaloAltoNetworksNgfwResourceGroupResource : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockablePaloAltoNetworksNgfwResourceGroupResource"/> class for mocking. </summary>
        protected MockablePaloAltoNetworksNgfwResourceGroupResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockablePaloAltoNetworksNgfwResourceGroupResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockablePaloAltoNetworksNgfwResourceGroupResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary> Gets a collection of PaloAltoNetworksFirewallResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of PaloAltoNetworksFirewallResources and their operations over a PaloAltoNetworksFirewallResource. </returns>
        public virtual PaloAltoNetworksFirewallCollection GetPaloAltoNetworksFirewalls()
        {
            return GetCachedClient(client => new PaloAltoNetworksFirewallCollection(client, Id));
        }

        /// <summary>
        /// Get a FirewallResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/PaloAltoNetworks.Cloudngfw/firewalls/{firewallName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Firewalls_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="PaloAltoNetworksFirewallResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="firewallName"> Firewall resource name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="firewallName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="firewallName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<PaloAltoNetworksFirewallResource>> GetPaloAltoNetworksFirewallAsync(string firewallName, CancellationToken cancellationToken = default)
        {
            return await GetPaloAltoNetworksFirewalls().GetAsync(firewallName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get a FirewallResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/PaloAltoNetworks.Cloudngfw/firewalls/{firewallName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Firewalls_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="PaloAltoNetworksFirewallResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="firewallName"> Firewall resource name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="firewallName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="firewallName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<PaloAltoNetworksFirewallResource> GetPaloAltoNetworksFirewall(string firewallName, CancellationToken cancellationToken = default)
        {
            return GetPaloAltoNetworksFirewalls().Get(firewallName, cancellationToken);
        }

        /// <summary> Gets a collection of LocalRulestackResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of LocalRulestackResources and their operations over a LocalRulestackResource. </returns>
        public virtual LocalRulestackCollection GetLocalRulestacks()
        {
            return GetCachedClient(client => new LocalRulestackCollection(client, Id));
        }

        /// <summary>
        /// Get a LocalRulestackResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/PaloAltoNetworks.Cloudngfw/localRulestacks/{localRulestackName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LocalRulestacks_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LocalRulestackResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="localRulestackName"> LocalRulestack resource name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="localRulestackName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="localRulestackName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<LocalRulestackResource>> GetLocalRulestackAsync(string localRulestackName, CancellationToken cancellationToken = default)
        {
            return await GetLocalRulestacks().GetAsync(localRulestackName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get a LocalRulestackResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/PaloAltoNetworks.Cloudngfw/localRulestacks/{localRulestackName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LocalRulestacks_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LocalRulestackResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="localRulestackName"> LocalRulestack resource name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="localRulestackName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="localRulestackName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<LocalRulestackResource> GetLocalRulestack(string localRulestackName, CancellationToken cancellationToken = default)
        {
            return GetLocalRulestacks().Get(localRulestackName, cancellationToken);
        }
    }
}
